<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\PropertiesMaterialsPicture;
use App\Models\PropertiesMaterialsFile;
use App\Models\PropertiesHoaFile;
use App\Models\PropertiesMaterial;
use App\Models\Property;

class PropertiesMaterial extends Model
{
    use HasFactory;
    protected $fillable = [
        'property_id',
        'material_type_id',
        'material_id',
        'property_location_id',
        'last_installed',
        'installed_by',
        'install_notes'
    ];    
    
    
    public static function getPropertyMaterials($property_id){
        
        if(empty($property_id)){
            return [];
        }
        
        $materials = parent::
            select(
                'properties_materials.*',
                'properties_locations.location as property_location'
                )
            ->join('properties_locations', 'properties_materials.property_location_id', '=', 'properties_locations.id')
            ->where(['properties_materials.property_id'=>$property_id])->get();
            
            
        $materials = (!empty($materials)) ? $materials->toArray() : [];
        
        for($i=0; $i<count($materials); $i++){
            
            $property_material_id = $materials[$i]['id'];
            
            $pictures = PropertiesMaterialsPicture::where(['property_material_id'=>$property_material_id])->get();
            $materials[$i]['pictures'] = (!empty($pictures)) ? $pictures->toArray() : [];
            
            $files = PropertiesMaterialsFile::where(['property_material_id'=>$property_material_id])->get();
            $materials[$i]['files'] = (!empty($files)) ? $files->toArray() : [];
            
        }
        
        return $materials;
        
        
    }
    
    public function getPropertyMaterialPictureOwner($picture_id){
        
        $material_id = PropertiesMaterialsPicture::select('property_material_id')->where('id', $picture_id)->get()->toArray()[0]['property_material_id'];
        $property_id = PropertiesMaterial::select('property_id')->where('id', $material_id)->get()->toArray()[0]['property_id'];
        $owner_id = Property::select('owner_id')->where('id', $property_id)->get()->toArray()[0]['owner_id'];
        
        return $owner_id;
        
    }
    
    public function getPropertyMaterialFileOwner($file_id){
        
        $material_id = PropertiesMaterialsFile::select('property_material_id')->where('id', $file_id)->get()->toArray()[0]['property_material_id'];
        $property_id = PropertiesMaterial::select('property_id')->where('id', $material_id)->get()->toArray()[0]['property_id'];
        $owner_id = Property::select('owner_id')->where('id', $property_id)->get()->toArray()[0]['owner_id'];
        
        return $owner_id;
        
    }
    
    public function getPropertyHoaFileOwner($file_id){
        
        $property_id = PropertiesHoaFile::select('property_id')->where('id', $file_id)->get()->toArray()[0]['property_id'];
        $owner_id = Property::select('owner_id')->where('id', $property_id)->get()->toArray()[0]['owner_id'];
        
        return $owner_id;
        
    }
    
}
