<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Image;

class UploadsController extends Controller
{

    public function uploadImage(Request $request){

        if ($request->image) {
            $folderPath = "uploads/";
            
            $base64Image = explode(";base64,", $request->image);
            $explodeImage = explode("image/", $base64Image[0]);
            $imageType = $explodeImage[1];
            $image_base64 = base64_decode($base64Image[1]);
            $file_name = uniqid() . '.'.$imageType;
            $file = $folderPath . $file_name;
            
            file_put_contents($file, $image_base64);

            $response = [
                'image'=> $file_name,
                'url' => asset('uploads/'.$file_name)
            ];

            return response()->json(['data' => $response]);

        }        

    }  
    
    public function uploadFile(Request $request){

        if ($request->file) {
            $folderPath = "uploads/";
            
            $base64File = explode(";base64,", $request->file);
            $explodeFile = explode("application/", $base64File[0]);
            $fileType = $explodeFile[1];
            $file_base64 = base64_decode($base64File[1]);
            $file_name = uniqid() . '.'.$fileType;
            $file = $folderPath . $file_name;
            
            file_put_contents($file, $file_base64);

            $response = [
                'file'=> $file_name,
                'url' => asset('uploads/'.$file_name)
            ];

            return response()->json(['data' => $response]);

        }        

    }


}