<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\PicturesFolder;
use App\Models\PicturesTemplate;

use Carbon\Carbon;

use App\Libraries\Generic;

class PicturesTemplatesController extends Controller
{
    
    protected $generic;
    protected $website_id;
    
    public function __construct(){
        
        $this->website_id = config('constants.website_id');
        $this->generic = new Generic();
        
    }
    
    public function getPictureTemplate(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-picture-template')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $template_id = $request->query('template_id');
        $template = PicturesTemplate::find($template_id);
        
        // check if template exists
        if(empty($template)){
            return response()->json(['message' => 'No Template Found']);
        }
        
        // check if have access to view or edit
        if($template->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        $template = $template->toArray();
            
        $template_id = $template['id'];
        $folders = PicturesFolder::select(['id', 'name', 'picture', 'order_number', 'parent_id', 'picture_template_id', 'name as title'])->where(['picture_template_id'=>$template_id])->get();
        
        $template['folders'] = [];
        
        if(!empty($folders)){
            $folders = $folders->toArray();
            $template['folders'] = $this->generic->parentChildTree($folders);
        }

        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['template' => $template] ]);
    }
    
    public function getMyPicturesTemplates()
    {
        
        $user_id = auth()->user()->id;
        
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-my-pictures-templates')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $templates = PicturesTemplate::select(['id', 'name'])->where(['owner_id'=>$owner_id])->get();
        
        $templates = (!empty($templates)) ? $templates->toArray() : [];
        
        for($i=0; $i<count($templates); $i++){
            
            $template_id = $templates[$i]['id'];
            $folders = PicturesFolder::select(['id', 'name', 'order_number', 'picture', 'parent_id', 'picture_template_id', 'name as title'])->where(['picture_template_id'=>$template_id])->get();
            
            $templates[$i]['folders'] = [];
            
            if(!empty($folders)){
                $folders = $folders->toArray();
                $templates[$i]['folders'] = $this->generic->parentChildTree($folders);
            }
            
        }
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['templates' => $templates] ]);
    }

    public function pictureTemplate(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('picture-template')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'name' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        //$update_criteria = [];
        
        PicturesTemplate::updateOrCreate(
            $update_criteria,
            [
                'name' => $request->name, 
                'owner_id' => $owner_id, 
                'created_by' => $user_id
            ]
        );

        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
    }
    
    public function pictureTemplateFolder(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('picture-template-folder')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'order_number' => 'required|numeric',
            'picture_template_id' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        //$update_criteria = [];
        
        PicturesFolder::updateOrCreate(
            $update_criteria,
            [
                'name' => $request->name, 
                'picture' => $request->picture,
                'order_number' => $request->order_number, 
                'path' => '',
                'parent_id' => !empty($request->parent_id) ? $request->parent_id : null,
                'picture_template_id' => $request->picture_template_id
            ]
        );

        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
    }
    
    public function parentChildTree(array $elements, $parentId = 0)
    {
         $branch = array();
        
        foreach ($elements as $element) {
            if ($element['parent_id'] == $parentId) {            
                
                $children = $this->parentChildTree($elements, $element['id']);
                if ($children) {
                   
                    $element['children'] = $children;
                   
                }
                $branch[] = $element;
            }
        }

        return $branch;
        
    }
    
    public function duplicatePictureTemplate(Request $request){
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('duplicate-picture-template')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'picture_template_id' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $picture_template_id = $request->picture_template_id;
        
        $template = PicturesTemplate::find($picture_template_id);
        
        $this->generic->duplicatePictureTemplate($picture_template_id, $request->name);
        
        // $template = PicturesTemplate::find($picture_template_id);
        
        // if(empty($template)){
        //     return response()->json(config('constants.messages.invalid_template'), 400);
        //     exit();
        // }
        
        // $template = $template->toArray();
        
        // $update_criteria = [];
        
        // // create template
        // $new_template = PicturesTemplate::create(
        //     [
        //         'name' => $request->name, 
        //         'owner_id' => $owner_id, 
        //         'created_by' => $user_id
        //     ]
        // );
        
        // $new_template_id = $new_template->id;
        
        // // now create folders structure
        // $folders = PicturesFolder::select(['id', 'name', 'order_number', 'picture', 'parent_id', 'picture_template_id'])->where(['picture_template_id'=>$picture_template_id])->get();
        
        // if(!empty($folders)){
            
        //     $folders = $folders->toArray();
        //     $maping_array = array();
            
        //     foreach($folders as $f){
                
        //         if($f['parent_id'] == null){
                    
        //             $new_folder = PicturesFolder::create(
        //                 [
        //                     'name' => $f['name'], 
        //                     'picture' => $f['picture'] ?? '', 
        //                     'order_number' => $f['order_number'], 
        //                     'path' => '',
        //                     'parent_id' => null,
        //                     'picture_template_id' => $new_template_id
        //                 ]
        //             );
                    
        //             $maping_array[$f['id']] = $new_folder->id;
                    
        //         }
        //         else{
                    
        //             $new_folder = PicturesFolder::create(
        //                 [
        //                     'name' => $f['name'], 
        //                     'picture' => $f['picture'] ?? '', 
        //                     'order_number' => $f['order_number'], 
        //                     'path' => '',
        //                     'parent_id' => $maping_array[$f['parent_id']],
        //                     'picture_template_id' => $new_template_id
        //                 ]
        //             );
                    
        //             $maping_array[$f['id']] = $new_folder->id;
                    
        //         }
                
        //     }
            
        // }
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
        
    }
    
    public function deletePictureTemplate(Request $request){
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('duplicate-picture-template')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $picture_template_id = $request->query('picture_template_id');
        
        $template = PicturesTemplate::find($picture_template_id);
        
        if(empty($template)){
            return response()->json(config('constants.messages.invalid_template'), 400);
            exit();
        }
        
        if($template->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        PicturesTemplate::find($picture_template_id)->delete();
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
        
    }
    
    public function deletePictureTemplateFolder(Request $request){
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('delete-picture-template-folder')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $picture_folder_id = $request->query('picture_folder_id');
        
        $folder = PicturesFolder::find($picture_folder_id);
        
        if(empty($folder)){
            return response()->json(config('constants.messages.invalid_folder'), 400);
            exit();
        }
        
        // get template 
        $picture_template_id = $folder->picture_template_id;
        
        $template = PicturesTemplate::find($picture_template_id);
        
        if($template->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        PicturesFolder::find($picture_folder_id)->delete();
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
        
    }
    
}