<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

use App\Models\GendersPreference;
use App\Models\Gender;
use App\Models\UsersRelationship;
use App\Models\InteractionsType;
use App\Models\VehiclesMake;
use App\Models\VehiclesModel;
use App\Models\PetsGender;
use App\Models\UsersReferencesRelationship;
use App\Models\PlacesWith;
use App\Models\SmokingPermission;
use App\Models\Timezone;
use App\Models\BoardsType;

use Carbon\Carbon;

class GeneralsController extends Controller
{
    
    protected $website_id;
    
    public function __construct(){
        
        $this->website_id = config('constants.website_id');
        
    }
    
    public function getGendersPreferences()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $genders_preferences = GendersPreference::select(['id', 'gender'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['genders_preferences' => $genders_preferences] ]);
    }
    
    public function getGenders()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $genders = Gender::select(['id', 'gender'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['genders' => $genders] ]);
    }
    
    public function getUsersRelationships()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $relationships = UsersRelationship::select(['id', 'relationship'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['relationships' => $relationships] ]);
    }
    
    public function getInteractionsTypes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $interactions_types = InteractionsType::select(['id', 'type'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['interactions_types' => $interactions_types] ]);
    }
    
    public function getVehiclesMakes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $vehicles_makes = VehiclesMake::select(['id', 'make'])->orderBy('make', 'asc')->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['vehicles_makes' => $vehicles_makes] ]);
    }
    
    public function getVehiclesModels(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $vehicle_make_id = $request->query('vehicle_make_id');
        $year = $request->query('year');

        $vehicles_models = VehiclesModel::where(['vehicle_make_id'=>$vehicle_make_id, 'year'=>$year])->select(['id', 'model', 'year'])->orderBy('model', 'asc')->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['vehicles_models' => $vehicles_models] ]);
    }
    
    public function getPetsGenders()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $pets_genders = PetsGender::select(['id', 'gender'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['pets_genders' => $pets_genders] ]);
    }
    
    public function getUsersReferencesRelationships()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $relationships = UsersReferencesRelationship::select(['id', 'relationship'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['relationships' => $relationships] ]);
    }
    
    public function getPlacesWiths()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $places_withs = PlacesWith::all();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['places_withs' => $places_withs] ]);
    }
    
    public function getSmokingPermissions()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $smoking_permissions = SmokingPermission::select(['id', 'title'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['smoking_permissions' => $smoking_permissions] ]);
    }
    
    
    
    public function getTimezones()
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $timezones = Timezone::select(['id', 'name', 'timezone'])->get();
        
        $timezones = (!empty($timezones)) ? $timezones->toArray() : [];
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['timezones' => $timezones] ]);
    }
    
    public function getBoardTypes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $board_types = BoardsType::select(['id', 'type'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['board_types' => $board_types] ]);
    }
    
    
}