<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\PropertiesFeature;

class PropertiesFeature extends Model
{
    use HasFactory;
    protected $fillable = [
        'property_id',
        'feature_id'
    ];    
    
    public function getPropertyFeatures($property_id)
    {
        
        if(empty($property_id)){
            return [];
        }
        
        $features = PropertiesFeature::
            select(
                'properties_features.*',
                'features.feature as feature_name'
                )
            ->join('features', 'properties_features.feature_id', '=', 'features.id')
            ->where(['property_id'=>$property_id])->get();
            
    
        return $features;
        
    }
    
}
