<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Material extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'material_status_id',
        'material_type_id',
        'material_brand_id',
        'color',
        'material_finish_id',
        'material_identifier_id',
        'material_vendor_id',
        'website',
        'material_unit_sold_by_id',
        'coverage_per_unit',
        'material_coverage_unit_id',
        'last_purchased',
        'units_purchased',
        'price_per_unit',
        'coverage_purchased',
        'material_on_hand',
        'coverage_on_hand',
        'property_location_id',
        'notes',
        'owner_id',
        'created_by'
    ];    
    
    
    public function pictures()
    {
        return $this->hasMany(MaterialsPicture::class);
    }
    
    public function files()
    {
        return $this->hasMany(MaterialsFile::class);
    }
}
