<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Application extends Model
{
    use HasFactory;
    protected $fillable = [
        'property_id',
        'unit_id',
        'application_link_id',
        'user_id',
        'application_status_id',
        'ever_evicted',
        'eviction_notes',
        'ever_convicted_of_felony',
        'convicted_of_felony_notes',
        'has_cosigners',
        'messy_clean',
        'loud_quiet',
        'extra_fields_json',
        'additional_information',
        'notes'
    ];    
    
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        
    ];
    
    public function files()
    {
        return $this->hasMany(ApplicationsFile::class);
    }
    
    public function cosigners()
    {
        return $this->hasMany(ApplicationsCosigner::class);
    }
    
    public function interactions()
    {
        return $this->hasMany(ApplicationsInteraction::class);
    }
    
    
}
