<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\AllPropertiesType;
use App\Models\Property;
use App\Models\PropertiesContact;
use App\Models\PropertiesSecuritiesContact;
use App\Models\PropertiesManager;
use App\Models\PropertiesPicture;
use App\Models\PropertiesMaterialsType;
use App\Models\PropertiesMaterialsLocation;
use App\Models\PropertiesMaterialsBrand;
use App\Models\PropertiesMaterialsIdentifier;
use App\Models\PropertiesMaterialsPicture;
use App\Models\PropertiesMaterialsFile;
use App\Models\PropertiesHoaFile;
use App\Models\PropertiesMaterial;
use App\Models\PropertiesMortageFile;
use App\Models\PropertiesBuildersFile;
use App\Models\PropertiesInsurance;
use App\Models\PropertiesInsurancesFile;
use App\Models\PropertiesInsurancesClaim;
use App\Models\PropertiesInsurancesClaimsFile;
use App\Models\PropertiesInsurancesClaimsResolutionFile;
use App\Models\PropertiesNotice;
use App\Models\PropertiesBoard;
use App\Models\PropertiesBoardsFile;
use App\Models\PropertiesFile;
use App\Models\PropertiesFilesFolder;
use App\Models\PropertiesManagersFile;
use App\Models\PropertiesOwnersFile;
use App\Models\PropertiesStaffFile;
use App\Models\PropertiesTenantsFile;
use App\Models\PropertiesFeature;
use App\Models\PropertiesMeasurement;
use App\Models\PropertiesNotification;
use App\Models\MeasurementsUnit;
use App\Models\PropertiesMeasurementsPicture;
use App\Models\PropertiesMeasurementsFile;
use App\Models\PropertiesParkingSpace;
use App\Models\PropertiesLocation;
use App\Models\PropertiesLocationsRole;
use App\Models\PropertiesLocationsRolesBase;
use App\Models\PicturesFolder;
use App\Models\PropertiesNearby;
use App\Models\PropertiesHoaContact;
use App\Models\PropertiesMortageContact;
use App\Models\PropertiesBuildersContact;
use App\Models\PropertiesHoaInteraction;
use App\Models\PropertiesMortageInteraction;
use App\Models\PropertiesBuildersInteraction;
use App\Models\PropertiesHoaInteractionsFile;
use App\Models\PropertiesMortageInteractionsFile;
use App\Models\PropertiesBuildersInteractionsFile;
use App\Models\PropertiesParkingsSpacesHistoryLogs;
use App\Models\PropertiesNote;
use App\Models\PropertiesNotesFile;


use App\Models\UsersRole;
use App\Models\User;
use Carbon\Carbon;
use DB;

use App\Libraries\Generic;


class PropertiesController extends Controller
{
    
    protected $generic;
    
    public function __construct(){
        
        $this->generic = new Generic();
        
    }
    
    public function property(Request $request){
        
        // echo "<pre>";
        // print_r($request->all());
        // exit();
        
        // return response()->json(['message' => 'Added Successfully', 'data'=> $request->all() ]);

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('add-edit-property')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'type_id' => 'required|numeric',
            'is_active' => 'required|min:0|max:1',
            'address_line_1' => 'required',
            'city' => 'required',
            'state' => 'required',
            'zip_code' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
            // echo "<pre>";
            // print_r( $request->all());
            // exit();

        $property = Property::updateOrCreate(
            $update_criteria, 
            [
                'name' => $request->name,
                'unique_id' => 'P-'.random_int(1000000000, 9999999999),
                'type_id' => $request->type_id,
                'is_active' => $request->is_active,
                'address_line_1' => $request->address_line_1,
                'address_line_2' => $request->address_line_2,
                'country' => $request->country,
                'city' => $request->city,
                'state' => $request->state,
                'zip_code' => $request->zip_code,
                'wifi_network' => $request->wifi_network ?? '',
                'wifi_password' => $request->wifi_password ?? '',
                'alarm_code' => $request->alarm_code ?? '',
                'gate_code' => $request->gate_code ?? '',
                'door_code' => $request->door_code ?? '',
                'mailbox_number' => $request->mailbox_number ?? '',
                'other_info' => $request->other_info ?? '',
                'picture_template_id' => $request->picture_template_id ?? null,
                'file_template_id' => $request->file_template_id ?? null,
                'no_of_floors' => $request->no_of_floors ?? 0,
                'has_stairs' => $request->has_stairs ?? 0,
                'has_elevator' => $request->has_elevator ?? 0,
                'description' => $request->description ?? '',
                'other_property_features' => $request->other_property_features ?? '',
                'embed' => $request->embed ?? '',
                'hoa_show_to_tenant' => $request->hoa_show_to_tenant ?? 0,
                'hoa_show_to_property_manager' => $request->hoa_show_to_property_manager ?? 0,
                'hoa_company' => $request->hoa_company ?? '',
                'hoa_contact_firstname' => $request->hoa_contact_firstname ?? '',
                'hoa_contact_lastname' => $request->hoa_contact_lastname ?? '',
                'hoa_contact_title' => $request->hoa_contact_title ?? '',
                'hoa_address_line1' => $request->hoa_address_line1 ?? '',
                'hoa_address_line2' => $request->hoa_address_line2 ?? '',
                'hoa_country' => $request->hoa_country ?? '',
                'hoa_city' => $request->hoa_city ?? '',
                'hoa_state' => $request->hoa_state ?? '',
                'hoa_zip_code' => $request->hoa_zip_code ?? '',
                'hoa_number1' => $request->hoa_number1 ?? '',
                'hoa_number1_type' => $request->hoa_number1_type ?? '',
                'hoa_number2' => $request->hoa_number2 ?? '',
                'hoa_number2_type' => $request->hoa_number2_type ?? '',
                'hoa_number3' => $request->hoa_number3 ?? '',
                'hoa_number3_type' => $request->hoa_number3_type ?? '',
                'hoa_email' => $request->hoa_email ?? '',
                'hoa_website' => $request->hoa_website ?? '',
                'hoa_fee' => $request->hoa_fee ?? '',
                'hoa_fee_show_to_tenant' => $request->hoa_fee_show_to_tenant ?? 0,
                'hoa_fee_show_to_property_manager' => $request->hoa_fee_show_to_property_manager ?? 0,
                'hoa_due_date' => $request->hoa_due_date ?? 1,
                'hoa_tenant_notes' => $request->hoa_tenant_notes ?? '',
                'hoa_property_manager_notes' => $request->hoa_property_manager_notes ?? '',
                'hoa_owner_notes' => $request->hoa_owner_notes ?? '',
                'mortage_company' => $request->mortage_company ?? '',
                'mortage_contact_firstname' => $request->mortage_contact_firstname ?? '',
                'mortage_contact_lastname' => $request->mortage_contact_lastname ?? '',
                'mortage_contact_title' => $request->mortage_contact_title ?? '',
                'mortage_address_line1' => $request->mortage_address_line1 ?? '',
                'mortage_address_line2' => $request->mortage_address_line2 ?? '',
                'mortage_country' => $request->mortage_country ?? '',
                'mortage_city' => $request->mortage_city ?? '',
                'mortage_state' => $request->mortage_state ?? '',
                'mortage_zip_code' => $request->mortage_zip_code ?? '',
                'mortage_number1' => $request->mortage_number1 ?? '',
                'mortage_number1_type' => $request->mortage_number1_type ?? '',
                'mortage_number2' => $request->mortage_number2 ?? '',
                'mortage_number2_type' => $request->mortage_number2_type ?? '',
                'mortage_number3' => $request->mortage_number3 ?? '',
                'mortage_number3_type' => $request->mortage_number3_type ?? '',
                'mortage_email' => $request->mortage_email ?? '',
                'mortage_website' => $request->mortage_website ?? '',
                'mortage_minimum_payment' => $request->mortage_minimum_payment ?? '',
                'mortage_due_date' => $request->mortage_due_date ?? 1,
                'mortage_balance' => $request->mortage_balance ?? '',
                'mortage_notes' => $request->mortage_notes ?? '',
                'builder_company' => $request->builder_company ?? '',
                'builder_date' => $request->builder_date ?? '',
                'builder_firstname' => $request->builder_firstname ?? '',
                'builder_lastname' => $request->builder_lastname ?? '',
                'builder_title' => $request->builder_title ?? '',
                'builder_address_line1' => $request->builder_address_line1 ?? '',
                'builder_address_line2' => $request->builder_address_line2 ?? '',
                'builder_country' => $request->builder_country ?? '',
                'builder_city' => $request->builder_city ?? '',
                'builder_state' => $request->builder_state ?? '',
                'builder_zip_code' => $request->builder_zip_code ?? '',
                'builder_number1' => $request->builder_number1 ?? '',
                'builder_number1_type' => $request->builder_number1_type ?? '',
                'builder_number2' => $request->builder_number2 ?? '',
                'builder_number2_type' => $request->builder_number2_type ?? '',
                'builder_number3' => $request->builder_number3 ?? '',
                'builder_number3_type' => $request->builder_number3_type ?? '',
                'builder_email' => $request->builder_email ?? '',
                'builder_website' => $request->builder_website ?? '',
                'builder_notes' => $request->builder_notes ?? '',
                'payment_info_company' => $request->payment_info_company ?? '',
                'payment_info_firstname' => $request->payment_info_firstname ?? '',
                'payment_info_lastname' => $request->payment_info_lastname ?? '',
                'payment_info_address_line1' => $request->payment_info_address_line1 ?? '',
                'payment_info_address_line2' => $request->payment_info_address_line2 ?? '',
                'payment_info_country' => $request->payment_info_country ?? '',
                'payment_info_city' => $request->payment_info_city ?? '',
                'payment_info_state' => $request->payment_info_state ?? '',
                'payment_info_zip_code' => $request->payment_info_zip_code ?? '',
                'payment_info_number' => $request->payment_info_number ?? '',
                'payment_info_email' => $request->payment_info_email ?? '',
                'payment_info_other_payment_information' => $request->payment_info_other_payment_information ?? '',
                'owner_id' => $owner_id,
                'creator_id' => $user_id
            ]
        );

        $property_id = $property->id;

        // property_locations
        // $property_locations = json_decode($request->property_locations, true);
        // $property_locations = (!empty($property_locations)) ? $property_locations : [];
        
        // print_r($property_locations);
        // exit();
        
        $property_locations = $request->property_locations ?? [];

        foreach($property_locations as $pl){
            
            $update_criteria = [];
            if(!empty($pl['id'])){
                $update_criteria['id'] = $pl['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $property_location = PropertiesLocation::updateOrCreate($update_criteria, [
                'location' => $pl['location'] ?? '',
                'description' => $pl['description'] ?? '',
                'can_reserve' => $pl['can_reserve'] ?? 0,
                'requires_approval' => $pl['requires_approval'] ?? 0,
                'deposit' => $pl['deposit'] ?? 0,
                'fee' => $pl['fee'] ?? 0,
                'different_options_per_role' => $pl['different_options_per_role'] ?? 0,
                'owner_id' => $owner_id,
                'property_id' => $property_id
            ]);
    
            $property_location_id = $property_location->id;
            
            // selected roles
            $roles = $pl['roles'];
            
            foreach($roles as $r){
                
                $update_criteria = [];
                if(!empty($r['id'])){
                    $update_criteria['id'] = $r['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesLocationsRole::updateOrCreate($update_criteria, [
                    'property_location_id' => $property_location_id,
                    'role_id' => $r['role_id'],
                ]);
                
            }
            
            // roles basis
            $roles_basis = $pl['roles_basis'];
            
            foreach($roles_basis as $r){
                
                $update_criteria = [];
                if(!empty($r['id'])){
                    $update_criteria['id'] = $r['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesLocationsRolesBase::updateOrCreate($update_criteria, [
                    'property_location_id' => $property_location_id,
                    'role_id' => $r['role_id'],
                    'requires_approval' => $r['requires_approval'] ?? 0,
                    'deposit' => $r['deposit'] ?? 0,
                    'fee' => $r['fee'] ?? 0
                ]);
                
            }
            
        }

        // notifications
        $notifications = $request->notifications ?? [];

        foreach($notifications as $n){
            
            $update_criteria = [];
            if(!empty($n['id'])){
                $update_criteria['id'] = $n['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $date = (!empty($n['posting_date'])) ? $this->generic->formatInputDate($n['posting_date']) : date('d-m-Y');
            $time = $n['posting_time'] ?? date('h:m:i A');
            $str = strtotime($date.' '.$time);
            
            PropertiesNotification::updateOrCreate($update_criteria, [
                'title' => $n['title'] ?? '',
                'notification' => $n['notification'] ?? '',
                'is_popup_notification' => $n['is_popup_notification'] ?? 0,
                'posting_date' => $date,
                'posting_time' => $time,
                'posting_date_time_str' => $str,
                'property_id' => $property_id
            ]);
            
        }
        
        // boards
        $boards = $request->boards ?? [];

        foreach($boards as $b){
            
            $update_criteria = [];
            if(!empty($b['id'])){
                $update_criteria['id'] = $b['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $board = PropertiesBoard::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'board_type_id' => $b['board_type_id'] ?? null,
                'title' => $b['title']  ?? '',
                'icon' => $b['icon'] ?? '',
                'board' => $b['board'] ?? 0,
                'link' => $b['link'] ?? '',
                'link_show_in' => $b['link_show_in'] ?? 0,
                'order_number' => $b['order_number'] ?? 1
            ]);
            
            $board_id = $board->id;
            
            $files = $b['files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesBoardsFile::updateOrCreate($update_criteria, [
                    'property_board_id' => $board_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
                
            }
            
        }

        // pictures
        $pictures = $request->pictures ?? [];

        foreach($pictures as $p){
            
            $update_criteria = [];
            if(!empty($p['id'])){
                $update_criteria['id'] = $p['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesPicture::updateOrCreate($update_criteria, [
                'picture' => $p['picture'],
                'title' => $p['title']  ?? '',
                'caption' => $p['caption']  ?? '',
                'is_cover' => $p['is_cover']  ?? 0,
                'order_number' => $p['order_number']  ?? 1,
                'property_id' => $property_id,
                'picture_folder_id' => $p['picture_folder_id'] ?? null,
            ]);
        }
        
        // property files
        $files = $request->property_files ?? [];

        foreach($files as $f){
            
            $update_criteria = [];
            if(!empty($f['id'])){
                $update_criteria['id'] = $f['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesFile::updateOrCreate($update_criteria, [
                'title' => $f['title'] ?? '',
                'file' => $f['file'],
                'property_id' => $property_id,
                'property_file_folder_id ' => $f['property_file_folder_id'] ?? null,
                'property_manager_sharing' => $f['property_manager_sharing'] ?? 0,
                'staff_sharing' => $f['staff_sharing'] ?? 0,
                'tenant_sharing' => $f['tenant_sharing'] ?? 0,
            ]);
        }
        
        // staff files
        // $staff_files = $request->property_staff_files ?? [];

        // foreach($staff_files as $f){
            
        //     $update_criteria = [];
        //     if(!empty($f['id'])){
        //         $update_criteria['id'] = $f['id'];
        //     }
        //     else{
        //         $update_criteria['id'] = 0;
        //     }
            
        //     PropertiesStaffFile::updateOrCreate($update_criteria, [
        //         'property_id' => $property_id,
        //         'title' => $f['title'] ?? '',
        //         'file' => $f['file']
        //     ]);
            
        // }
        
        // // managers files
        // $manager_files = $request->property_manager_files ?? [];

        // foreach($manager_files as $f){
            
        //     $update_criteria = [];
        //     if(!empty($f['id'])){
        //         $update_criteria['id'] = $f['id'];
        //     }
        //     else{
        //         $update_criteria['id'] = 0;
        //     }
            
        //     PropertiesManagersFile::updateOrCreate($update_criteria, [
        //         'property_id' => $property_id,
        //         'title' => $f['title'] ?? '',
        //         'file' => $f['file']
        //     ]);
            
        // }
        
        // tenant files
        // $property_tenant_files = $request->property_tenant_files ?? [];

        // foreach($property_tenant_files as $f){
            
        //     $update_criteria = [];
        //     if(!empty($f['id'])){
        //         $update_criteria['id'] = $f['id'];
        //     }
        //     else{
        //         $update_criteria['id'] = 0;
        //     }
            
        //     PropertiesTenantsFile::updateOrCreate($update_criteria, [
        //         'property_id' => $property_id,
        //         'file' => $f['file']
        //     ]);
            
        // }
        
        // owner files
        // $owner_files = $request->property_owner_files ?? [];

        // foreach($owner_files as $f){
            
        //     $update_criteria = [];
        //     if(!empty($f['id'])){
        //         $update_criteria['id'] = $f['id'];
        //     }
        //     else{
        //         $update_criteria['id'] = 0;
        //     }
            
        //     PropertiesOwnersFile::updateOrCreate($update_criteria, [
        //         'property_id' => $property_id,
        //         'title' => $f['title'] ?? '',
        //         'file' => $f['file']
        //     ]);
            
        // }
        
        // property notes
        $notes = $request->property_notes ?? [];

        foreach($notes as $n){
            
            $update_criteria = [];
            if(!empty($n['id'])){
                $update_criteria['id'] = $n['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $note = PropertiesNote::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'title' => $n['title'] ?? '',
                'note' => $n['note'] ?? '',
                'property_manager_sharing' => $n['property_manager_sharing'] ?? 'hidden',
                'staff_sharing' => $n['staff_sharing'] ?? 'hidden',
                'tenant_sharing' => $n['tenant_sharing'] ?? 'hidden'
            ]);
            
            $note_id = $note->id;
            
            $files = $n['files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesNotesFile::updateOrCreate($update_criteria, [
                    'property_note_id' => $note_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        // // property staff notes
        // $notes = $request->property_staff_notes ?? [];

        // foreach($notes as $n){
            
        //     $update_criteria = [];
        //     if(!empty($n['id'])){
        //         $update_criteria['id'] = $n['id'];
        //     }
        //     else{
        //         $update_criteria['id'] = 0;
        //     }
            
        //     PropertiesNote::updateOrCreate($update_criteria, [
        //         'property_id' => $property_id,
        //         'note' => $n['note'] ?? '',
        //         'type' => 'staff',
        //     ]);
        // }
        
        // // property manager notes
        // $notes = $request->property_manager_notes ?? [];

        // foreach($notes as $n){
            
        //     $update_criteria = [];
        //     if(!empty($n['id'])){
        //         $update_criteria['id'] = $n['id'];
        //     }
        //     else{
        //         $update_criteria['id'] = 0;
        //     }
            
        //     PropertiesNote::updateOrCreate($update_criteria, [
        //         'property_id' => $property_id,
        //         'note' => $n['note'] ?? '',
        //         'type' => 'manager',
        //     ]);
        // }
        
        // // property owner notes
        // $notes = $request->property_owner_notes ?? [];

        // foreach($notes as $n){
            
        //     $update_criteria = [];
        //     if(!empty($n['id'])){
        //         $update_criteria['id'] = $n['id'];
        //     }
        //     else{
        //         $update_criteria['id'] = 0;
        //     }
            
        //     PropertiesNote::updateOrCreate($update_criteria, [
        //         'property_id' => $property_id,
        //         'note' => $n['note'] ?? '',
        //         'type' => 'owner',
        //     ]);
        // }
        
        // contacts
        $contacts = $request->contacts ?? [];

        foreach($contacts as $c){
            
            $update_criteria = [];
            if(!empty($c['id'])){
                $update_criteria['id'] = $c['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesContact::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'firstname' => $c['firstname']  ?? '',
                'lastname' => $c['lastname'] ?? '',
                'title' => $c['title'] ?? '',
                'number1' => $c['number1'] ?? '',
                'number1_type' => $c['number1_type'] ?? '',
                'number2' => $c['number2'] ?? '',
                'number2_type' => $c['number2_type'] ?? '',
                'number3' => $c['number3'] ?? '',
                'number3_type' => $c['number3_type'] ?? '',
                'email' => $c['email'] ?? '',
                'info' => $c['info'] ?? '',
                'picture' => $c['picture'] ?? '',                
            ]);
        }
        
        // securities contacts
        $contacts = $request->securities_contacts ?? [];

        foreach($contacts as $c){
            
            $update_criteria = [];
            if(!empty($c['id'])){
                $update_criteria['id'] = $c['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesSecuritiesContact::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'firstname' => $c['firstname'] ?? '',
                'lastname' => $c['lastname'] ?? '',
                'title' => $c['title'] ?? '',
                'number1' => $c['number1'] ?? '',
                'number1_type' => $c['number1_type'] ?? '',
                'number2' => $c['number2'] ?? '',
                'number2_type' => $c['number2_type'] ?? '',
                'number3' => $c['number3'] ?? '',
                'number3_type' => $c['number3_type'] ?? '',
                'email' => $c['email'] ?? '',
                'info' => $c['info'] ?? '',
                'picture' => $c['picture'] ?? ''                
            ]);
        }
        
        // measurements
        $measurements = $request->measurements ?? [];

        foreach($measurements as $m){
            
            $update_criteria = [];
            if(!empty($m['id'])){
                $update_criteria['id'] = $m['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $measurement = PropertiesMeasurement::updateOrCreate($update_criteria, [
                'name' => $m['name'],
                'property_id' => $property_id,
                'measurement_type_id' => $m['measurement_type_id'],
                'property_location_id' => $m['property_location_id'],
                'measurement_unit_id' => $m['measurement_unit_id'],
                'length' => $m['length'] ?? "",
                'width' => $m['width'] ?? "",
                'height' => $m['height'] ?? "",
                'depth' => $m['depth'] ?? "",
                'amount' => $m['amount'] ?? "",
                'notes' => $m['notes'] ?? ""
            ]);
            
            $property_measurement_id = $measurement->id;
            
            $pictures = $m['pictures'];
            
            foreach($pictures as $p){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $p['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesMeasurementsPicture::updateOrCreate($update_criteria, [
                    'property_measurement_id' => $property_measurement_id,
                    'picture' => $p['picture'],
                    'order_number' => $p['order_number']
                ]);
                
            }
            
            $files = $m['files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesMeasurementsFile::updateOrCreate($update_criteria, [
                    'property_measurement_id' => $property_measurement_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        // materials
        $materials = $request->materials ?? [];

        foreach($materials as $m){
            
            $update_criteria = [];
            if(!empty($m['id'])){
                $update_criteria['id'] = $m['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $material = PropertiesMaterial::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'material_type_id' => $m['material_type_id'],
                'material_id' => $m['material_id'],
                'property_location_id' => $m['property_location_id'],
                'last_installed' => $m['last_installed'] ?? '',
                'installed_by' => null,
                'install_notes' => $m['install_notes'] ?? ''
            ]);
            
            $property_material_id = $material->id;
            
            $pictures = $m['pictures'];
            
            foreach($pictures as $p){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $p['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesMaterialsPicture::updateOrCreate($update_criteria, [
                    'property_material_id' => $property_material_id,
                    'picture' => $p['picture'],
                    'order_number' => $p['order_number']
                ]);
                
            }
            
            $files = $m['files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesMaterialsFile::updateOrCreate($update_criteria, [
                    'property_material_id' => $property_material_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        // parking space
        $parking_spaces = $request->parking_spaces ?? [];

        foreach($parking_spaces as $ps){
            
            $update_criteria = [];
            if(!empty($ps['id'])){
                $update_criteria['id'] = $ps['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesParkingSpace::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'space_number' => $ps['space_number'] ?? '',
                'parking_space_prefix_id' => $ps['parking_space_prefix_id'] ?? null,
                'parking_space_suffix_id' => $ps['parking_space_suffix_id'] ?? null,
                'compact' => $ps['compact'] ?? 0,
                'tandem' => $ps['tandem'] ?? 0,
                'electric_vehicle_charging' => $ps['electric_vehicle_charging'] ?? 0,
                'handicap' => $ps['handicap'] ?? 0
            ]);
        }
        
        // features
        $features = $request->features ?? [];

        foreach($features as $f){
            
            $update_criteria = [];
            if(!empty($f['id'])){
                $update_criteria['id'] = $f['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesFeature::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'feature_id' => $f['feature_id']
            ]);
        }
        
        // features
        $nearbys = $request->nearbys ?? [];

        foreach($nearbys as $n){
            
            $update_criteria = [];
            if(!empty($n['id'])){
                $update_criteria['id'] = $n['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesNearby::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'nearby_id' => $n['nearby_id']
            ]);
        }
        
        // hoa files
        $hoa_files = $request->hoa_files ?? [];

        foreach($hoa_files as $f){
            
            $update_criteria = [];
            if(!empty($f['id'])){
                $update_criteria['id'] = $f['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesHoaFile::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
            
        }
        
        // hoa contacts
        $hoa_contacts = $request->hoa_contacts ?? [];

        foreach($hoa_contacts as $c){
            
            $update_criteria = [];
            if(!empty($c['id'])){
                $update_criteria['id'] = $c['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesHoaContact::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'user_prefix_id' => $c['user_prefix_id'] ?? null,
                'firstname' => $c['firstname']  ?? '',
                'lastname' => $c['lastname'] ?? '',
                'title' => $c['title'] ?? '',
                'number1' => $c['number1'] ?? '',
                'number1_type' => $c['number1_type'] ?? '',
                'number2' => $c['number2'] ?? '',
                'number2_type' => $c['number2_type'] ?? '',
                'number3' => $c['number3'] ?? '',
                'number3_type' => $c['number3_type'] ?? '',
                'email' => $c['email'] ?? ''             
            ]);
        }
        
        // hoa interactions
        $hoa_interactions = $request->hoa_interactions ?? [];

        foreach($hoa_interactions as $i){
            
            $update_criteria = [];
            if(!empty($i['id'])){
                $update_criteria['id'] = $i['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $date = (!empty($i['date'])) ? $this->generic->formatInputDate($i['date']) : date('d-m-Y');
            $time = $i['time'] ?? date('h:m:i A');
            
            $interaction = PropertiesHoaInteraction::updateOrCreate($update_criteria, [
                'date' => $date,
                'time' => $time,
                'interaction_type_id' => $i['interaction_type_id'] ?? null,
                'other_type_description' => $i['other_type_description'] ?? '',
                'notes' => $i['notes'] ?? '',
                'property_id' => $property_id,
            ]);
            
            $interaction_id = $interaction->id;
            
            $files = $i['files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($f['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesHoaInteractionsFile::updateOrCreate($update_criteria, [
                    'property_hoa_interaction_id' => $interaction_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        
        // mortage files
        $mortage_files = $request->mortage_files ?? [];

        foreach($mortage_files as $f){
            
            $update_criteria = [];
            if(!empty($f['id'])){
                $update_criteria['id'] = $f['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesMortageFile::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
            
        }
        
        // mortage contacts
        $mortage_contacts = $request->mortage_contacts ?? [];

        foreach($mortage_contacts as $c){
            
            $update_criteria = [];
            if(!empty($c['id'])){
                $update_criteria['id'] = $c['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesMortageContact::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'user_prefix_id' => $c['user_prefix_id'] ?? null,
                'firstname' => $c['firstname'] ?? '',
                'lastname' => $c['lastname'] ?? '',
                'title' => $c['title'] ?? '',
                'number1' => $c['number1'] ?? '',
                'number1_type' => $c['number1_type'] ?? '',
                'number2' => $c['number2'] ?? '',
                'number2_type' => $c['number2_type'] ?? '',
                'number3' => $c['number3'] ?? '',
                'number3_type' => $c['number3_type'] ?? '',
                'email' => $c['email'] ?? ''             
            ]);
        }
        
        // hoa interactions
        $mortage_interactions = $request->mortage_interactions ?? [];

        foreach($mortage_interactions as $i){
            
            $update_criteria = [];
            if(!empty($i['id'])){
                $update_criteria['id'] = $i['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $date = (!empty($i['date'])) ? $this->generic->formatInputDate($i['date']) : date('d-m-Y');
            $time = $i['time'] ?? date('h:m:i A');
            
            $interaction = PropertiesMortageInteraction::updateOrCreate($update_criteria, [
                'date' => $date,
                'time' => $time,
                'interaction_type_id' => $i['interaction_type_id'] ?? null,
                'other_type_description' => $i['other_type_description'] ?? '',
                'notes' => $i['notes'] ?? '',
                'property_id' => $property_id,
            ]);
            
            $interaction_id = $interaction->id;
            
            $files = $i['files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($f['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesMortageInteractionsFile::updateOrCreate($update_criteria, [
                    'property_mortage_interaction_id' => $interaction_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        // builders files
        $builder_files = $request->builder_files ?? [];

        foreach($builder_files as $f){
            
            $update_criteria = [];
            if(!empty($f['id'])){
                $update_criteria['id'] = $f['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesBuildersFile::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
            
        }
        
        // builder contacts
        $builder_contacts = $request->builder_contacts ?? [];

        foreach($builder_contacts as $c){
            
            $update_criteria = [];
            if(!empty($c['id'])){
                $update_criteria['id'] = $c['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesBuildersContact::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'user_prefix_id' => $c['user_prefix_id'] ?? null,
                'firstname' => $c['firstname'] ?? '',
                'lastname' => $c['lastname'] ?? '',
                'title' => $c['title'] ?? '',
                'number1' => $c['number1'] ?? '',
                'number1_type' => $c['number1_type'] ?? '',
                'number2' => $c['number2'] ?? '',
                'number2_type' => $c['number2_type'] ?? '',
                'number3' => $c['number3'] ?? '',
                'number3_type' => $c['number3_type'] ?? '',
                'email' => $c['email'] ?? ''             
            ]);
        }
        
        // builder interactions
        $builder_interactions = $request->builder_interactions ?? [];

        foreach($builder_interactions as $i){
            
            $update_criteria = [];
            if(!empty($i['id'])){
                $update_criteria['id'] = $i['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $date = (!empty($i['date'])) ? $this->generic->formatInputDate($i['date']) : date('d-m-Y');
            $time = $i['time'] ?? date('h:m:i A');
            
            $interaction = PropertiesBuildersInteraction::updateOrCreate($update_criteria, [
                'date' => $date,
                'time' => $time,
                'interaction_type_id' => $i['interaction_type_id'] ?? null,
                'other_type_description' => $i['other_type_description'] ?? '',
                'notes' => $i['notes'] ?? '',
                'property_id' => $property_id,
            ]);
            
            $interaction_id = $interaction->id;
            
            $files = $i['files'];
            
            foreach($files as $f){ 
                
                $update_criteria = []; 
                if(!empty($f['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesBuildersInteractionsFile::updateOrCreate($update_criteria, [
                    'property_builder_interaction_id' => $interaction_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        // insurances
        $insurances = $request->insurances ?? [];

        foreach($insurances as $i){
            
            $update_criteria = [];
            if(!empty($i['id'])){
                $update_criteria['id'] = $i['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $insurance = PropertiesInsurance::updateOrCreate($update_criteria, [
                'company' => $i['company'],
                'property_id' => $property_id,
                'company' => $i['company'],
                'property_insurance_type_id' => $i['property_insurance_type_id'],
                'policy_number' => $i['policy_number'] ?? '',
                'start_date' => $i['start_date'] ?? '',
                'end_date' => $i['end_date'] ?? '',
                'contact_firstname' => $i['contact_firstname'] ?? '',
                'contact_lastname' => $i['contact_lastname'] ?? '',
                'contact_title' => $i['contact_title'] ?? '',
                'address_line1' => $i['address_line1'] ?? '',
                'address_line2' => $i['address_line2'] ?? '',
                'city' => $i['city'] ?? '',
                'state' => $i['state'] ?? '',
                'zip_code' => $i['zip_code'] ?? '',
                'number1' => $i['number1'] ?? '',
                'number1_type' => $i['number1_type'] ?? '',
                'number2' => $i['number2'] ?? '',
                'number2_type' => $i['number2_type'] ?? '',
                'number3' => $i['number3'] ?? '',
                'number3_type' => $i['number3_type'] ?? '',
                'email' => $i['email'] ?? '',
                'website' => $i['website'] ?? '',
                'premium' => $i['premium'] ?? '',
                'frequency' => $i['frequency'] ?? '',
                'due_date' => $i['due_date'] ?? '',
                'deductible' => $i['deductible'] ?? '',
                'notes' => $i['notes'] ?? ''
            ]);
            
            $property_insurance_id = $insurance->id;
            
            $files = $i['files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesInsurancesFile::updateOrCreate($update_criteria, [
                    'property_insurance_id' => $property_insurance_id,
                    
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        // insurances claims
        $insurances_claims = $request->insurances_claims ?? [];

        foreach($insurances_claims as $i){
            
            $update_criteria = [];
            if(!empty($i['id'])){
                $update_criteria['id'] = $i['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $insurance_claim = PropertiesInsurancesClaim::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'date_of_claim' => $i['date_of_claim'],
                'case_number' => $i['case_number'],
                'title' => $i['title'],
                'description' => $i['description'],
                'status' => $i['status'] ?? '',
                'agent_firstname' => $i['agent_firstname'] ?? '',
                'agent_lastname' => $i['agent_lastname'] ?? '',
                'agent_title' => $i['agent_title'] ?? '',
                'number1' => $i['number1'] ?? '',
                'number1_type' => $i['number1_type'] ?? '',
                'number2' => $i['number2'] ?? '',
                'number2_type' => $i['number2_type'] ?? '',
                'number3' => $i['number3'] ?? '',
                'number3_type' => $i['number3_type'] ?? '',
                'email' => $i['email'] ?? '',
                'notes' => $i['notes'] ?? '',
                'date_closed' => $i['date_closed'] ?? '',
                'resolution_notes' => $i['resolution_notes'] ?? ''
            ]);
            
            $property_insurance_claim_id = $insurance_claim->id;
            
            $files = $i['claim_files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesInsurancesClaimsFile::updateOrCreate($update_criteria, [
                    'property_insurance_claim_id' => $property_insurance_claim_id,
                    'file' => $f['file']
                ]);
                
            }
            
            $files = $i['claim_resolution_files'];
            
            foreach($files as $f){
                
                $update_criteria = [];
                if(!empty($p['id'])){
                    $update_criteria['id'] = $f['id'];
                }
                else{
                    $update_criteria['id'] = 0;
                }
                
                PropertiesInsurancesClaimsResolutionFile::updateOrCreate($update_criteria, [
                    'property_insurance_claim_id' => $property_insurance_claim_id,
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        // notices
        $notices = $request->notices ?? [];

        foreach($notices as $n){
            
            $update_criteria = [];
            if(!empty($n['id'])){
                $update_criteria['id'] = $n['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            PropertiesNotice::updateOrCreate($update_criteria, [
                'property_id' => $property_id,
                'title' => $n['title'] ?? '',
                'notice' => $n['notice'] ?? '',
                'show_as_popup' => $n['show_as_popup'] ?? 0
            ]);
            
        }

        return response()->json(['message' => 'Added Successfully', 'data'=> $property_id ]);

    }

    public function getProperty(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('get-property')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $property_id = $request->query('property_id');
        $property = Property::find($property_id);
        
        // check if property exists
        if(empty($property)){
            return response()->json(['message' => 'No property found']);
        }
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }

        $property = $property->toArray();

        $property['property_locations'] =     PropertiesLocation::getPropertyLocations($property_id);
        $property['notifications'] =    Property::find($property_id)->notifications;
        $property['boards'] =           Property::find($property_id)->boards;
        $property['pictures'] =         Property::find($property_id)->pictures;
        $property['files'] =            Property::find($property_id)->files;
        $property['staff_files'] =      Property::find($property_id)->staffFiles;
        $property['managers_files'] =   Property::find($property_id)->managersFiles;
        $property['owners_files'] =     Property::find($property_id)->ownersFiles;
        
        $property['property_notes'] =     Property::allNotes($property_id);
        
        // $property['property_notes'] =               PropertiesNote::notes($property_id);
        // $property['property_staff_notes'] =         PropertiesNote::staffNotes($property_id);
        // $property['property_managers_notes'] =      PropertiesNote::managerNotes($property_id);
        // $property['property_owners_notes'] =        PropertiesNote::ownerNotes($property_id);
        
        $property['contacts'] =         Property::find($property_id)->contacts;
        $property['securities_ontacts'] =         Property::find($property_id)->securitiesContacts;
        $property['measurements'] =     PropertiesMeasurement::getPropertyMeasurements($property_id);
        $property['materials'] =        PropertiesMaterial::getPropertyMaterials($property_id);
        
        $property['features'] =         PropertiesFeature::getPropertyFeatures($property_id);
        $property['nearbys'] =          PropertiesNearby::getPropertyNearbys($property_id);
        $property['hoa_files'] =        Property::find($property_id)->hoaFiles;
        $property['hoa_contacts'] =     Property::find($property_id)->hoaContacts;
        $property['hoa_interactions'] = Property::hoaInteractions($property_id);
        $property['mortage_files'] =    Property::find($property_id)->mortageFiles;
        $property['mortage_contacts'] =     Property::find($property_id)->mortageContacts;
        $property['mortage_interactions'] = Property::mortageInteractions($property_id);
        $property['builder_files'] =    Property::find($property_id)->builderFiles;
        $property['builder_contacts'] =     Property::find($property_id)->builderContacts;
        $property['builder_interactions'] = Property::builderInteractions($property_id);
        $property['insurances'] =       Property::find($property_id)->insurances;
        $property['insurance_claims'] = Property::find($property_id)->insuranceClaims;
        $property['notices'] =          Property::find($property_id)->notices;
        $property['managers'] =         Property::find($property_id)->managers;
        
        // parking spaces
        $parking_spaces =   Property::find($property_id)->parkingSpaces;
        for($i=0; $i<count($parking_spaces); $i++){
            if($parking_spaces[$i]['is_assigned']){
                $parking_space_id = $parking_spaces[$i]['id'];
                $parking_spaces[$i]['assigned_to'] = PropertiesParkingsSpacesHistoryLogs::
                            select(['properties_parkings_spaces_history_logs.*', 'users.firstname', 'users.lastname', 'units.name as unit_name'])
                            ->where(['property_space_parking_id'=>$parking_space_id])
                            ->leftJoin('users', 'users.id', '=', 'properties_parkings_spaces_history_logs.tenant_id')
                            ->leftJoin('units', 'units.id', '=', 'properties_parkings_spaces_history_logs.unit_id')
                            ->get();
                
            }
        }
        
        $property['parking_spaces'] = $parking_spaces;
        
        return response()->json(['data' => $property]);
    }

    public function getMyProperties()
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-my-properties')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $properties = Property::
                        select(['properties.id', 'properties.name', 'properties.unique_id', 'properties.type_id', 'properties.is_active', 'properties.address_line_1', 'properties.address_line_2', 'properties.country', 'properties.city', 'properties.state', 'properties.zip_code', 'countries.country as country_name', 'states.state as state_name', 'cities.city as city_name'])
                        ->leftjoin('countries', 'properties.country', '=', 'countries.id')
                        ->leftjoin('states', 'properties.state', '=', 'states.id')
                        ->leftjoin('cities', 'properties.city', '=', 'cities.id')
                        ->where('properties.owner_id', $owner_id)
                        ->get();
                
        for($i=0; $i<count($properties); $i++){
            $properties[$i]['units_count'] = Property::find($properties[$i]['id'])->units->count();
        }
                
        return response()->json(['data' => $properties]);
    }
    
    public function markPropertiesAsActive(Request $request){
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('add-edit-property')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        // print_r($request->all());
        // exit();
        
        $validator = Validator::make($request->all(), [
            'ids' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $ids = $request->ids;
        
        foreach($ids as $id){
            Property::where(['id'=>$id])->update(['is_active'=>1]);
        }
        
        return response()->json(['message' => 'Updated Successfully']);
        
    }
    
    public function markPropertiesAsInactive(Request $request){
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('add-edit-property')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'ids' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $ids = $request->ids;
        
        foreach($ids as $id){
            Property::where(['id'=>$id])->update(['is_active'=>0]);
        }
        
        return response()->json(['message' => 'Updated Successfully']);
        
    }

    public function getAllPropertiesTypes(){

        $all_properties_types = AllPropertiesType::select('id', 'type')->get()->toArray();

        return response()->json(['data' => $all_properties_types]);

    }
    
    public function deleteProperty(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-property')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $property_id = $request->query('property_id');
        $property = Property::find($property_id);
        
        // check if property exists
        if(empty($property)){
            return response()->json(['message' => 'No property found']);
        }
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        Property::find($property_id)->delete();
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    public function deleteProperties(Request $request){
        
        // check if permission to do
        if(!User::checkPermission('delete-properties')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        
        $validator = Validator::make($request->all(), [
            'ids' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $ids = $request->ids ?? [];
        
        foreach($ids as $property_id){
            $property = Property::find($property_id);
            
            if(!empty($property)){
                if($property->owner_id == $owner_id){
                    Property::find($property_id)->delete();
                }
            }
            
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    public function duplicateProperty(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('duplicate-property')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'property_id' => 'required|numeric',
            'name' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $property_id = $request->property_id;
        $property = Property::find($property_id);
        
        // check if property exists
        if(empty($property)){
            return response()->json(['message' => 'No property found']);
        }
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }

        // $property = $property->toArray();
        
        // before start duplicating property, duplicate pictures folder template that this property is using
        $new_picture_template_folders_maping = [];
        $new_picture_template_id = null;
        if(!empty($property->picture_template_id)){
            $old_picture_template_id = $property->picture_template_id;
            $new_picture_template_id = $this->generic->duplicatePictureTemplate($old_picture_template_id, '');
            
            $old_picture_template_folders = PicturesFolder::where(['picture_template_id'=>$old_picture_template_id])->get();
            $old_picture_template_folders = (!empty($old_picture_template_folders)) ? $old_picture_template_folders->toArray() : [];
            
            $new_picture_template_folders = PicturesFolder::where(['picture_template_id'=>$new_picture_template_id])->get();
            $new_picture_template_folders = (!empty($new_picture_template_folders)) ? $new_picture_template_folders->toArray() : [];
            
            for($i=0; $i<count($new_picture_template_folders); $i++){
                $new_picture_template_folders_maping[$old_picture_template_folders[$i]['id']] = $new_picture_template_folders[$i]['id'];
            }
        }
        
        // before start duplicating property, duplicate files folder template that this property is using
        $new_file_template_folders_maping = [];
        $new_file_template_id = null;
        if(!empty($property->file_template_id)){
            $old_file_template_id = $property->file_template_id;
            $new_file_template_id = $this->generic->duplicateFileTemplate($old_file_template_id, '');
            
            $old_file_template_folders = FilesFolder::where(['file_template_id'=>$old_file_template_id])->get();
            $old_file_template_folders = (!empty($old_file_template_folders)) ? $old_file_template_folders->toArray() : [];
            
            $new_file_template_folders = FilesFolder::where(['file_template_id'=>$new_file_template_id])->get();
            $new_file_template_folders = (!empty($new_file_template_folders)) ? $new_file_template_folders->toArray() : [];
            
            for($i=0; $i<count($new_file_template_folders); $i++){
                $new_file_template_folders_maping[$old_file_template_folders[$i]['id']] = $new_file_template_folders[$i]['id'];
            }
        }
        
        // property basic info
        $new_property = Property::create(
            [
                'name' => $request->name ?? $property->name,
                'unique_id' => 'P-'.random_int(1000000000, 9999999999),
                'type_id' => $property->type_id,
                'is_active' => $property->is_active,
                'address_line_1' => $property->address_line_1,
                'address_line_2' => $property->address_line_2,
                'country' => $property->country,
                'city' => $property->city,
                'state' => $property->state,
                'zip_code' => $property->zip_code,
                'wifi_network' => $property->wifi_network ?? '',
                'wifi_password' => $property->wifi_password ?? '',
                'alarm_code' => $property->alarm_code ?? '',
                'gate_code' => $property->gate_code ?? '',
                'door_code' => $property->door_code ?? '',
                'mailbox_number' => $property->mailbox_number ?? '',
                'other_info' => $property->other_info ?? '',
                'picture_template_id' => $new_picture_template_id,
                'file_template_id' => $new_file_template_id,
                'no_of_floors' => $property->no_of_floors ?? 0,
                'has_stairs' => $property->has_stairs ?? 0,
                'has_elevator' => $property->has_elevator ?? 0,
                'description' => $property->description ?? '',
                'other_property_features' => $property->other_property_features ?? '',
                'embed' => $property->embed ?? '',
                'hoa_show_to_tenant' => $property->hoa_show_to_tenant ?? 0,
                'hoa_show_to_property_manager' => $property->hoa_show_to_property_manager ?? 0,
                'hoa_company' => $property->hoa_company ?? '',
                'hoa_contact_firstname' => $property->hoa_contact_firstname ?? '',
                'hoa_contact_lastname' => $property->hoa_contact_lastname ?? '',
                'hoa_contact_title' => $property->hoa_contact_title ?? '',
                'hoa_address_line1' => $property->hoa_address_line1 ?? '',
                'hoa_address_line2' => $property->hoa_address_line2 ?? '',
                'hoa_city' => $property->hoa_city ?? '',
                'hoa_state' => $property->hoa_state ?? '',
                'hoa_zip_code' => $property->hoa_zip_code ?? '',
                'hoa_number1' => $property->hoa_number1 ?? '',
                'hoa_number1_type' => $property->hoa_number1_type ?? '',
                'hoa_number2' => $property->hoa_number2 ?? '',
                'hoa_number2_type' => $property->hoa_number2_type ?? '',
                'hoa_number3' => $property->hoa_number3 ?? '',
                'hoa_number3_type' => $property->hoa_number3_type ?? '',
                'hoa_email' => $property->hoa_email ?? '',
                'hoa_website' => $property->hoa_website ?? '',
                'hoa_fee' => $property->hoa_fee ?? '',
                'hoa_fee_show_to_tenant' => $property->hoa_fee_show_to_tenant ?? 0,
                'hoa_fee_show_to_property_manager' => $property->hoa_fee_show_to_property_manager ?? 0,
                'hoa_due_date' => $property->hoa_due_date ?? 1,
                'hoa_tenant_notes' => $property->hoa_tenant_notes ?? '',
                'hoa_property_manager_notes' => $property->hoa_property_manager_notes ?? '',
                'hoa_owner_notes' => $property->hoa_owner_notes ?? '',
                'mortage_company' => $property->mortage_company ?? '',
                'mortage_contact_firstname' => $property->mortage_contact_firstname ?? '',
                'mortage_contact_lastname' => $property->mortage_contact_lastname ?? '',
                'mortage_contact_title' => $property->mortage_contact_title ?? '',
                'mortage_address_line1' => $property->mortage_address_line1 ?? '',
                'mortage_address_line2' => $property->mortage_address_line2 ?? '',
                'mortage_city' => $property->mortage_city ?? '',
                'mortage_state' => $property->mortage_state ?? '',
                'mortage_zip_code' => $property->mortage_zip_code ?? '',
                'mortage_number1' => $property->mortage_number1 ?? '',
                'mortage_number1_type' => $property->mortage_number1_type ?? '',
                'mortage_number2' => $property->mortage_number2 ?? '',
                'mortage_number2_type' => $property->mortage_number2_type ?? '',
                'mortage_number3' => $property->mortage_number3 ?? '',
                'mortage_number3_type' => $property->mortage_number3_type ?? '',
                'mortage_email' => $property->mortage_email ?? '',
                'mortage_website' => $property->mortage_website ?? '',
                'mortage_minimum_payment' => $property->mortage_minimum_payment ?? '',
                'mortage_due_date' => $property->mortage_due_date ?? 1,
                'mortage_balance' => $property->mortage_balance ?? '',
                'mortage_notes' => $property->mortage_notes ?? '',
                'builder_company' => $property->builder_company ?? '',
                'builder_date' => $property->builder_date ?? '',
                'builder_firstname' => $property->builder_firstname ?? '',
                'builder_lastname' => $property->builder_lastname ?? '',
                'builder_title' => $property->builder_title ?? '',
                'builder_address_line1' => $property->builder_address_line1 ?? '',
                'builder_address_line2' => $property->builder_address_line2 ?? '',
                'builder_city' => $property->builder_city ?? '',
                'builder_state' => $property->builder_state ?? '',
                'builder_zip_code' => $property->builder_zip_code ?? '',
                'builder_number1' => $property->builder_number1 ?? '',
                'builder_number1_type' => $property->builder_number1_type ?? '',
                'builder_number2' => $property->builder_number2 ?? '',
                'builder_number2_type' => $property->builder_number2_type ?? '',
                'builder_number3' => $property->builder_number3 ?? '',
                'builder_number3_type' => $property->builder_number3_type ?? '',
                'builder_email' => $property->builder_email ?? '',
                'builder_website' => $property->builder_website ?? '',
                'builder_notes' => $property->builder_notes ?? '',
                'payment_info_company' => $property->payment_info_company ?? '',
                'payment_info_firstname' => $property->payment_info_firstname ?? '',
                'payment_info_lastname' => $property->payment_info_lastname ?? '',
                'payment_info_address_line1' => $property->payment_info_address_line1 ?? '',
                'payment_info_address_line2' => $property->payment_info_address_line2 ?? '',
                'payment_info_country' => $property->payment_info_country ?? '',
                'payment_info_city' => $property->payment_info_city ?? '',
                'payment_info_state' => $property->payment_info_state ?? '',
                'payment_info_zip_code' => $property->payment_info_zip_code ?? '',
                'payment_info_number' => $property->payment_info_number ?? '',
                'payment_info_email' => $property->payment_info_email ?? '',
                'payment_info_other_payment_information' => $property->payment_info_other_payment_information ?? '',
                'owner_id' => $owner_id,
                'creator_id' => $user_id
            ]
        );
        
        $new_property_id = $new_property->id;
        
        // property location
        $property_locations = PropertiesLocation::getPropertyLocations($property_id);
        $property_locations = (!empty($property_locations)) ? $property_locations : [];
        
        foreach($property_locations as $pl){
            
            $property_location = PropertiesLocation::create([
                'location' => $pl['location'],
                'description' => $pl['description'],
                'can_reserve' => $pl['can_reserve'],
                'requires_approval' => $pl['requires_approval'],
                'deposit' => $pl['deposit'],
                'fee' => $pl['fee'],
                'different_options_per_role' => $pl['different_options_per_role'],
                'owner_id' => $owner_id,
                'property_id' => $new_property_id
            ]);
            
            $property_location_id = $property_location->id;
            
            // selected roles
            $roles = $pl['roles'];
            
            foreach($roles as $r){
                
                PropertiesLocationsRole::create([
                    'property_location_id' => $property_location_id,
                    'role_id' => $r['role_id'],
                ]);
                
            }
            
            // roles basis
            $roles_basis = $pl['roles_basis'];
            
            foreach($roles_basis as $r){
                
                PropertiesLocationsRolesBase::create([
                    'property_location_id' => $property_location_id,
                    'role_id' => $r['role_id'],
                    'requires_approval' => $r['requires_approval'],
                    'deposit' => $r['deposit'],
                    'fee' => $r['fee']
                ]);
                
            }
            
        }
        
        // notifications
        $notifications = Property::find($property_id)->notifications;
        $notifications = (!empty($notifications)) ? $notifications : [];

        foreach($notifications as $n){
            
            PropertiesNotification::create([
                'title' => $n['title'],
                'notification' => $n['notification'],
                'is_popup_notification' => $n['is_popup_notification'],
                'posting_date' => $n['posting_date'],
                'posting_time' => $n['posting_time'],
                'posting_date_time_str' => $n['posting_date_time_str'],
                'property_id' => $new_property_id
            ]);
            
        }
        
        // boards
        $boards = Property::find($property_id)->boards;
        $boards = (!empty($boards)) ? $boards : [];

        foreach($boards as $b){
            
            PropertiesBoard::create([
                'property_id' => $new_property_id,
                'board_type_id' => $b['board_type_id'],
                'title' => $b['title'],
                'icon' => $b['icon'],
                'board' => $b['board'],
                'link' => $b['link'],
                'link_show_in' => $b['link_show_in'],
                'order_number' => $b['order_number']
            ]);
            
        }
        
        // pictures
        $pictures = Property::find($property_id)->pictures;
        $pictures = (!empty($pictures)) ? $pictures : [];

        foreach($pictures as $p){
            
            PropertiesPicture::create([
                'picture' => $p['picture'],
                'title' => $p['title'],
                'caption' => $p['caption'],
                'is_cover' => $p['is_cover'],
                'order_number' => $p['order_number'],
                'property_id' => $new_property_id,
                'picture_folder_id' => (isset($new_picture_template_folders_maping[$p['picture_folder_id']])) ? $new_picture_template_folders_maping[$p['picture_folder_id']] : null,
            ]);
        }
        
        // property files
        $files = Property::find($property_id)->files;
        $files = (!empty($files)) ? $files : [];

        foreach($files as $f){
            PropertiesFile::create([
                'title' => $f['title'] ?? '',
                'file' => $f['file'],
                'property_id' => $new_property_id,
                'file_folder_id' => (isset($new_file_template_folders_maping[$f['file_folder_id']])) ? $new_file_template_folders_maping[$f['file_folder_id']] : null,
            ]);
        }
        
        // staff files
        $staff_files = Property::find($property_id)->staffFiles;
        $staff_files = (!empty($staff_files)) ? $staff_files : [];

        foreach($staff_files as $f){
            PropertiesStaffFile::create([
                'property_id' => $new_property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
        }
        
        // managers files
        $manager_files = Property::find($property_id)->managersFiles;
        $manager_files = (!empty($manager_files)) ? $manager_files : [];

        foreach($manager_files as $f){
            PropertiesManagersFile::create([
                'property_id' => $new_property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
        }
        
        // owner files
        $owner_files = Property::find($property_id)->ownersFiles;
        $owner_files = (!empty($owner_files)) ? $owner_files : [];

        foreach($owner_files as $f){
            PropertiesOwnersFile::create([
                'property_id' => $new_property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
        }
        
        // all notes
        $notes = Property::find($property_id)->allNotes;
        $notes = (!empty($notes)) ? $notes : [];

        foreach($notes as $n){
            PropertiesNote::create([
                'property_id' => $new_property_id,
                'title' => $n['title'] ?? '',
                'note' => $n['note'] ?? '',
                'property_manager_sharing' => $n['property_manager_sharing'] ?? 'hidden',
                'staff_sharing' => $n['staff_sharing'] ?? 'hidden',
                'tenant_sharing' => $n['tenant_sharing'] ?? 'hidden'
            ]);
        }
        
        // contacts
        $contacts = Property::find($property_id)->contacts;
        $contacts = (!empty($contacts)) ? $contacts : [];

        foreach($contacts as $c){
            PropertiesContact::create([
                'property_id' => $new_property_id,
                'firstname' => $c['firstname'],
                'lastname' => $c['lastname'],
                'title' => $c['title'],
                'number1' => $c['number1'],
                'number1_type' => $c['number1_type'],
                'number2' => $c['number2'],
                'number2_type' => $c['number2_type'],
                'number3' => $c['number3'],
                'number3_type' => $c['number3_type'],
                'email' => $c['email'],
                'info' => $c['info'],
                'picture' => $c['picture'],                
            ]);
        }
        
        // securities contacts
        $contacts = Property::find($property_id)->securitiesContacts;
        $contacts = (!empty($contacts)) ? $contacts : [];

        foreach($contacts as $c){
            
            PropertiesSecuritiesContact::create([
                'property_id' => $new_property_id,
                'firstname' => $c['firstname'],
                'lastname' => $c['lastname'],
                'title' => $c['title'],
                'number1' => $c['number1'],
                'number1_type' => $c['number1_type'],
                'number2' => $c['number2'],
                'number2_type' => $c['number2_type'],
                'number3' => $c['number3'],
                'number3_type' => $c['number3_type'],
                'email' => $c['email'],
                'info' => $c['info'],
                'picture' => $c['picture'],                
            ]);
        }
        
        // measurements
        $measurements = PropertiesMeasurement::getPropertyMeasurements($property_id);
        $measurements = (!empty($measurements)) ? $measurements : [];

        foreach($measurements as $m){
            
            $measurement = PropertiesMeasurement::create([
                'name' => $m['name'],
                'property_id' => $new_property_id,
                'measurement_type_id' => $m['measurement_type_id'],
                'property_location_id' => $m['property_location_id'],
                'measurement_unit_id' => $m['measurement_unit_id'],
                'length' => $m['length'] ?? "",
                'width' => $m['width'] ?? "",
                'height' => $m['height'] ?? "",
                'depth' => $m['depth'] ?? "",
                'amount' => $m['amount'] ?? "",
                'notes' => $m['notes'] ?? ""
            ]);
            
            $property_measurement_id = $measurement->id;
            
            $pictures = $m['pictures'];
            
            foreach($pictures as $p){
                PropertiesMeasurementsPicture::create([
                    'property_measurement_id' => $property_measurement_id,
                    'picture' => $p['picture'],
                    'order_number' => $p['order_number']
                ]);
            }
            
            $files = $m['files'];
            
            foreach($files as $f){
                PropertiesMeasurementsFile::create([
                    'property_measurement_id' => $property_measurement_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
            }
            
        }
        
        // materials
        $materials = PropertiesMaterial::getPropertyMaterials($property_id);
        $materials = (!empty($materials)) ? $materials : [];

        foreach($materials as $m){
            
            $material = PropertiesMaterial::create([
                'property_id' => $new_property_id,
                'material_type_id' => $m['material_type_id'],
                'material_id' => $m['material_id'],
                'property_location_id' => $m['property_location_id'],
                'last_installed' => $m['last_installed'] ?? '',
                'installed_by' => $m['installed_by'] ?? null,
                'install_notes' => $m['install_notes'] ?? ''
            ]);
            
            $property_material_id = $material->id;
            
            $pictures = $m['pictures'];
            
            foreach($pictures as $p){
                
                PropertiesMaterialsPicture::create([
                    'property_material_id' => $property_material_id,
                    'picture' => $p['picture'],
                    'order_number' => $p['order_number']
                ]);
                
            }
            
            $files = $m['files'];
            
            foreach($files as $f){
                
                PropertiesMaterialsFile::create([
                    'property_material_id' => $property_material_id,
                    'title' => $f['title'] ?? '',
                    'file' => $f['file']
                ]);
                
            }
            
        }
        
        // parking space
        $parking_spaces = Property::find($property_id)->parkingSpaces;
        $parking_spaces = (!empty($parking_spaces)) ? $parking_spaces : [];

        foreach($parking_spaces as $ps){
            
            PropertiesParkingSpace::create([
                'property_id' => $new_property_id,
                'space_number' => $ps['space_number'] ?? '',
                'parking_space_prefix_id' => $ps['parking_space_prefix_id'] ?? null,
                'parking_space_suffix_id' => $ps['parking_space_suffix_id'] ?? null,
                'compact' => $ps['compact'] ?? 0,
                'tandem' => $ps['tandem'] ?? 0,
                'electric_vehicle_charging' => $ps['electric_vehicle_charging'] ?? 0,
                'handicap' => $ps['handicap'] ?? 0
            ]);
        }
        
        // features
        $features = PropertiesFeature::getPropertyFeatures($property_id);
        $features = (!empty($features)) ? $features : [];

        foreach($features as $f){
            PropertiesFeature::create([
                'property_id' => $new_property_id,
                'feature_id' => $f['feature_id']
            ]);
        }
        
        // nearbys
        $nearbys = PropertiesNearby::getPropertyNearbys($property_id);
        $nearbys = (!empty($nearbys)) ? $nearbys : [];

        foreach($nearbys as $n){
            PropertiesNearby::create([
                'property_id' => $new_property_id,
                'nearby_id' => $n['nearby_id']
            ]);
        }
        
        // hoa files
        $hoa_files = Property::find($property_id)->hoaFiles;
        $hoa_files = (!empty($hoa_files)) ? $hoa_files : [];

        foreach($hoa_files as $f){
            
            PropertiesHoaFile::create([
                'property_id' => $new_property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
            
        }
        
        // mortage files
        $mortage_files = Property::find($property_id)->mortageFiles;
        $mortage_files = (!empty($mortage_files)) ? $mortage_files : [];

        foreach($mortage_files as $f){
            
            PropertiesMortageFile::create([
                'property_id' => $new_property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
            
        }
        
        // builders files
        $builder_files = Property::find($property_id)->builderFiles;
        $builder_files = (!empty($builder_files)) ? $builder_files : [];

        foreach($builder_files as $f){
            
            PropertiesBuildersFile::create([
                'property_id' => $new_property_id,
                'title' => $f['title'] ?? '',
                'file' => $f['file']
            ]);
            
        }
        
        // // insurances
        // $insurances = Property::find($property_id)->insurances;
        // $insurances = (!empty($insurances)) ? $insurances : [];

        // foreach($insurances as $i){
            
        //     $insurance = PropertiesInsurance::create([
        //         'company' => $i['company'],
        //         'property_id' => $new_property_id,
        //         'company' => $i['company'],
        //         'property_insurance_type_id' => $i['property_insurance_type_id'],
        //         'policy_number' => $i['policy_number'] ?? '',
        //         'start_date' => $i['start_date'] ?? '',
        //         'end_date' => $i['end_date'] ?? '',
        //         'contact_firstname' => $i['contact_firstname'] ?? '',
        //         'contact_lastname' => $i['contact_lastname'] ?? '',
        //         'contact_title' => $i['contact_title'] ?? '',
        //         'address_line1' => $i['address_line1'] ?? '',
        //         'address_line2' => $i['address_line2'] ?? '',
        //         'city' => $i['city'] ?? '',
        //         'state' => $i['state'] ?? '',
        //         'zip_code' => $i['zip_code'] ?? '',
        //         'number1' => $i['number1'] ?? '',
        //         'number1_type' => $i['number1_type'] ?? '',
        //         'number2' => $i['number2'] ?? '',
        //         'number2_type' => $i['number2_type'] ?? '',
        //         'number3' => $i['number3'] ?? '',
        //         'number3_type' => $i['number3_type'] ?? '',
        //         'email' => $i['email'] ?? '',
        //         'website' => $i['website'] ?? '',
        //         'premium' => $i['premium'] ?? '',
        //         'frequency' => $i['frequency'] ?? '',
        //         'due_date' => $i['due_date'] ?? '',
        //         'deductible' => $i['deductible'] ?? '',
        //         'notes' => $i['notes'] ?? ''
        //     ]);
            
        //     $property_insurance_id = $insurance->id;
            
        //     $files = $i['files'];
            
        //     foreach($files as $f){
                
        //         PropertiesInsurancesFile::create([
        //             'property_insurance_id' => $property_insurance_id,
        //             'file' => $f['file']
        //         ]);
                
        //     }
            
        // }
        
        // // insurances claims
        // $insurances_claims = Property::find($property_id)->insuranceClaims;
        // $insurances_claims = (!empty($insurances_claims)) ? $insurances_claims : [];

        // foreach($insurances_claims as $i){
            
        //     $insurance_claim = PropertiesInsurancesClaim::create([
        //         'property_id' => $new_property_id,
        //         'date_of_claim' => $i['date_of_claim'],
        //         'case_number' => $i['case_number'],
        //         'title' => $i['title'],
        //         'description' => $i['description'],
        //         'status' => $i['status'] ?? '',
        //         'agent_firstname' => $i['agent_firstname'] ?? '',
        //         'agent_lastname' => $i['agent_lastname'] ?? '',
        //         'agent_title' => $i['agent_title'] ?? '',
        //         'number1' => $i['number1'] ?? '',
        //         'number1_type' => $i['number1_type'] ?? '',
        //         'number2' => $i['number2'] ?? '',
        //         'number2_type' => $i['number2_type'] ?? '',
        //         'number3' => $i['number3'] ?? '',
        //         'number3_type' => $i['number3_type'] ?? '',
        //         'email' => $i['email'] ?? '',
        //         'notes' => $i['notes'] ?? '',
        //         'date_closed' => $i['date_closed'] ?? '',
        //         'resolution_notes' => $i['resolution_notes'] ?? ''
        //     ]);
            
        //     $property_insurance_claim_id = $insurance_claim->id;
            
        //     $files = $i['claim_files'];
            
        //     foreach($files as $f){
                
        //         PropertiesInsurancesClaimsFile::create([
        //             'property_insurance_claim_id' => $property_insurance_claim_id,
        //             'file' => $f['file']
        //         ]);
                
        //     }
            
        //     $files = $i['claim_resolution_files'];
            
        //     foreach($files as $f){
                
        //         PropertiesInsurancesClaimsResolutionFile::create([
        //             'property_insurance_claim_id' => $property_insurance_claim_id,
        //             'file' => $f['file']
        //         ]);
                
        //     }
            
        // }
        
        // notices
        $notices = Property::find($property_id)->notices;
        $notices = (!empty($notices)) ? $notices : [];

        foreach($notices as $n){
            
            PropertiesNotice::create([
                'property_id' => $new_property_id,
                'title' => $n['title'],
                'notice' => $n['notice'],
                'show_as_popup' => $n['show_as_popup'] ?? 0
            ]);
            
        }
        
        
        return response()->json(['data' => $new_property_id]);
    }
    
    public function bulkUnassignParkingSpaces(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('bulk-unassign-parking-spaces')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'parking_spaces_ids' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $parking_spaces_ids = $request->parking_spaces_ids;
        foreach($parking_spaces_ids as $ps_id){
            $parking_space = PropertiesParkingSpace::where(['id'=>$ps_id])->first();
            
            if(!empty($parking_space)){
                PropertiesParkingsSpacesHistoryLogs::where(['property_space_parking_id'=>$parking_space->id])->update(['end_date'=>date('d-m-Y')]);
                PropertiesParkingSpace::where(['id'=>$parking_space->id])->update(['is_assigned'=>0]);
            }
            
        }

        return response()->json(['message' => 'success', 'data' => []]);
    }
    
    public function getParkingSpaceHistory(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('get-parking-space-history')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $parking_space_id = $request->query('parking_space_id');
        $parking_space = PropertiesParkingSpace::find($parking_space_id);
        
        // check if parking space exists
        if(empty($parking_space)){
            return response()->json(['message' => 'No parking space found']);
        }
        $history_logs = PropertiesParkingsSpacesHistoryLogs::
                        select(['properties_parkings_spaces_history_logs.*', 'users.firstname', 'users.lastname', 'units.name as unit_name'])
                        ->where(['property_space_parking_id'=>$parking_space_id])
                        ->leftJoin('users', 'users.id', '=', 'properties_parkings_spaces_history_logs.tenant_id')
                        ->leftJoin('units', 'units.id', '=', 'properties_parkings_spaces_history_logs.unit_id')
                        ->get();
                        
        return response()->json(['data' => $history_logs]);
    }
    
    public function getMeasurementsUnits(Request $request){

        $user_id = auth()->user()->id;

        // if logged in
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
        }
        
        $measurements_units = MeasurementsUnit::select(['id', 'unit'])->get();
        
        return response()->json(['message' => 'Success', 'data'=> ['measurements_units' => $measurements_units] ]);

    }
    
    public function getParkingSpacesByProperty(Request $request){
        
        // echo "<pre>";
        // print_r($request->all());
        // exit();

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-parking-spaces-by-property')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $property_id = $request->query('property_id');
        $property = Property::find($property_id);
        
        // check if parking space exists
        if(empty($property)){
            return response()->json(['message' => 'No Property Found']);
        }
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        $parking_spaces = Property::find($property_id)->parkingSpaces;
        
        for($i=0; $i<count($parking_spaces); $i++){
            
            if($parking_spaces[$i]['is_assigned']){
                
                $parking_space_id = $parking_spaces[$i]['id'];
                
                $parking_spaces[$i]['assigned_to'] = PropertiesParkingsSpacesHistoryLogs::
                            select(['properties_parkings_spaces_history_logs.*', 'users.firstname', 'users.lastname', 'units.name as unit_name'])
                            ->where(['property_space_parking_id'=>$parking_space_id])
                            ->leftJoin('users', 'users.id', '=', 'properties_parkings_spaces_history_logs.tenant_id')
                            ->leftJoin('units', 'units.id', '=', 'properties_parkings_spaces_history_logs.unit_id')
                            ->get();
                
            }
            
        }
        
        
        return response()->json(['data' => $parking_spaces]);
        
    }
    
    public function assignSingleParkingSpace(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('assign-single-parking-space')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'property_parking_space_id' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $property_parking_space_id = $request->property_parking_space_id;
        $property_parking_space = PropertiesParkingSpace::find($property_parking_space_id);
        
        if(empty($property_parking_space)){
            return response()->json(['message' => 'No parking space found']);
        }
        
        $property = Property::find($property_parking_space->property_id);
        
        if(empty($property)){
            return response()->json(['message' => 'Invalid parking space']);
        }
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        PropertiesParkingsSpacesHistoryLogs::create([
            'property_space_parking_id' => $property_parking_space_id,
            'tenant_id' => $request->tenant_id ?? null,
            'unit_id' => $request->unit_id ?? null,
            'start_date' => date('d-m-Y'),
            'end_date' => ''
        ]);
        
        // now mark parking space as assigned
        PropertiesParkingSpace::where(['id'=>$property_parking_space_id])->update(['is_assigned'=>1]);
        
        return response()->json(['message' => 'success', 'data' => []]);
    }

    public function rearrangePropertyBoards(Request $request){
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('rearrange-property-boards')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'property_id' => 'required',
            'data' => 'required'
        ]);
        
        if ($validator->fails()) { 
            return response()->json($validator->errors(), 400);
        }
        
        $property_id = $request->property_id;
        $data = $request->data;
        
        $property = Property::find($property_id);
        
        // check if property exists
        if(empty($property)){
            return response()->json(['message' => 'No property found']);
        }
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
            
        foreach($data as $d){
            $id = $d['id'];
            $order_number = $d['order_number'];
            PropertiesBoard::where(['id'=>$id, 'property_id'=>$property_id])->update(['order_number'=>$order_number]);
        }
        
        $boards = Property::find($property_id)->boards;
        
        return response()->json(['message' => 'Updated Successfully', 'data' => $boards]);

    }
    
    public function propertyFileFolder(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('property-file-folder')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'order_number' => 'required|numeric',
            'property_id' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        $folder = PropertiesFilesFolder::updateOrCreate(
            $update_criteria,
            [
                'name' => $request->name, 
                'picture' => $request->picture ?? '',
                'order_number' => $request->order_number, 
                'parent_id' => $request->parent_id ?? null,
                'property_id' => $request->property_id,
                'property_manager_sharing' => $request->property_manager_sharing ?? 0,
                'staff_sharing' => $request->staff_sharing ?? 0,
                'tenant_sharing' => $request->tenant_sharing ?? 0,
            ]
        );

        return response()->json(['message' => 'Success', 'data'=> $folder->id ]);
        
    }
    
    public function getPropertyFileFolders(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-property-file-folders')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $property_id = $request->query('property_id');
        $property = Property::find($property_id);
        
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        $folders = PropertiesFilesFolder::select(['*', 'name as title'])->where(['property_id' => $property_id])->get();
        
        if(!empty($folders)){
            $folders = $folders->toArray();
            $folders = $this->generic->parentChildTree($folders);
        }
        
        return response()->json(['message' => 'Success', 'data'=> ['folders' => $folders] ]);
        
    }
    
    public function deletePropertyFileFolder(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-property-file-folder')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $folder_id = $request->query('folder_id');
        $folder = PropertiesFilesFolder::find($folder_id);
        
        // check if folder exists
        if(empty($folder)){
            return response()->json(['message' => 'No folder found']);
        }
        
        $property_id = $folder->property_id;
        
        $property = Property::find($property_id);
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        PropertiesFilesFolder::find($folder_id)->delete();
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    public function changePropertyFolderPermission(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('change-property-folder-permission')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'folder_id' => 'required|numeric',
            'property_manager_sharing' => 'required|numeric',
            'staff_sharing' => 'required|numeric',
            'tenant_sharing' => 'required|numeric',
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $folder_id = $request->folder_id;
        
        $folder = PropertiesFilesFolder::find($folder_id);
        
        // check if folder exists
        if(empty($folder)){
            return response()->json(['message' => 'No folder found']);
        }
        
        $property_id = $folder->property_id;
        
        $property = Property::find($property_id);
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }
        
        $folders_raw = DB::select('select parent_id as p_id from properties_files_folders where parent_id = @pv2 union select id from (select * from properties_files_folders order by parent_id, id) s, (select @pv2 := '.$folder_id.') initialisation where find_in_set(parent_id, @pv2) > 0 and @pv2 := concat(@pv2,",", id)');
        $folders_raw = (!empty($folders_raw)) ? json_decode(json_encode($folders_raw), true) : [];
        
        // if empty subchildren then fetch folder it self
        $folders_raw[0]['p_id'] = $folder['id'];
        
        $folders = [];
        
        foreach($folders_raw as $f){
            array_push($folders, $f['p_id']);
        }
        
        $data = [
            'property_manager_sharing' => $request->property_manager_sharing,
            'staff_sharing' => $request->staff_sharing,
            'tenant_sharing' => $request->tenant_sharing
        ];
        
        PropertiesFilesFolder::whereIn('id', $folders)->update($data);
        PropertiesFile::whereIn('property_file_folder_id', $folders)->update($data);
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
    }

}