<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\OwnersSetting;

use App\Models\PetsType;

use Carbon\Carbon;

class OwnersController extends Controller
{
    
    protected $website_id;
    
    public function __construct(){
        
        $this->website_id = config('constants.website_id');
        
    }
    
    public function getCurrentOwnerSettings()
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-current-owner-settings')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $owners_settings = OwnersSetting::select(['date_format', 'time_format', 'time_zone_id', 'currency_symbol', 'currency_format', 'phone_number_format'])->where(['owner_id'=>$owner_id])->first();
        
        $owners_settings = (!empty($owners_settings)) ? $owners_settings->toArray() : [];
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['owners_settings' => $owners_settings] ]);
    }

    public function setCurrentOwnerSettings(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('set-current-owner-settings')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'date_format' => 'required',
            'time_format' => 'required',
            'time_zone_id' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria['owner_id'] = $user_id;
        
        OwnersSetting::updateOrCreate(
            $update_criteria,
            [ 
                'owner_id' => $user_id, 
                'date_format' => $request->date_format, 
                'time_format' => $request->time_format, 
                'time_zone_id' => $request->time_zone_id, 
                'currency_symbol' => $request->currency_symbol, 
                'currency_format' => $request->currency_format, 
                'phone_number_format' => $request->phone_number_format, 
            ]
        );

        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
    }
    
    // -------------------------------------------------------------------------------------
    
    public function addMyPetsType(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-my-pets-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'type' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
            // echo "<pre>";
            // print_r( $request->all());
            // exit();
            
        PetsType::updateOrCreate(
            $update_criteria, 
            [
                'type' => $request->type,
                'default_deposit' => $request->default_deposit ?? 0,
                'default_rent' => $request->default_rent ?? 0,
                'default_shots' => $request->default_shots ?? '',
                'owner_id' => $user_id
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getMyPetsTypes()
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $types = PetsType::select(['id', 'type', 'default_deposit', 'default_rent', 'default_shots'])->where(['owner_id'=>$owner_id])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['types' => $types] ]);
    }
    
    
}