<?php
namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

use App\Models\GendersPreference;
use App\Models\ParkingSpacePrefix;
use App\Models\ParkingSpaceSuffix;
use App\Models\NamesPrefix;
use App\Models\NamesSuffix;
use App\Models\MoveoutReason;
use App\Models\Ethnicity;
use App\Models\NumbersType;
use App\Models\AllowedPicturesType;
use App\Models\AllowedFilesType;
use App\Models\Nearby;
use App\Models\MaterialsSellingsUnit;
use App\Models\MaterialsCoverageUnit;
use App\Models\MaterialsUnitsSoldBy;
use App\Models\ChangelogsCategory;
use App\Models\GeneralsIcon;
use App\Models\WebsiteSetting;
use App\Models\EvictionsReason;
use App\Models\VendorsCategory;
use App\Models\Feature;
use App\Models\AllPropertiesType;
use App\Models\AllUnitsType;
use App\Models\Country;
use App\Models\State;
use App\Models\City;
use App\Models\VehiclesMake;
use App\Models\VehiclesModel;

use App\Models\User;

use Carbon\Carbon;
use DB;

class AdminsController extends Controller
{
    
    protected $website_id;
    
    public function __construct(){
        
        $this->website_id = config('constants.website_id');
        
    }
    
    public function parkingSpacePrefix(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-parking-space-prefix')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'prefix' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
            // echo "<pre>";
            // print_r( $request->all());
            // exit();
            
        ParkingSpacePrefix::updateOrCreate(
            $update_criteria, 
            [
                'prefix' => $request->prefix,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getParkingSpacePrefixes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $prefixes = ParkingSpacePrefix::select(['id', 'prefix', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['prefixes' => $prefixes] ]);
    }
    
    public function deleteParkingSpacePrefix(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-parking-space-prefix')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = ParkingSpacePrefix::find($id);
        
        if(!empty($exists)){
            ParkingSpacePrefix::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // ----------------------------------------------------------------------------------
    
    
    public function parkingSpaceSuffix(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-parking-space-suffix')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'suffix' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
            // echo "<pre>";
            // print_r( $request->all());
            // exit();
            
        ParkingSpaceSuffix::updateOrCreate(
            $update_criteria, 
            [
                'suffix' => $request->suffix,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getParkingSpaceSuffixes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $suffixes = ParkingSpaceSuffix::select(['id', 'suffix', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['suffixes' => $suffixes] ]);
    }
    
    public function deleteParkingSpaceSuffix(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-parking-space-suffix')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = ParkingSpaceSuffix::find($id);
        
        if(!empty($exists)){
            ParkingSpaceSuffix::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // --------------------------------------------------------------------------------------------
    
    public function namePrefix(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-name-prefix')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'prefix' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
            // echo "<pre>";
            // print_r( $request->all());
            // exit();
            
        NamesPrefix::updateOrCreate(
            $update_criteria, 
            [
                'prefix' => $request->prefix,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getNamePrefixes(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $sort = $request->query('sort') ?? 'asc';
        
        $prefixes = NamesPrefix::select(['id', 'prefix', 'icon', 'order_number'])->orderBy('prefix', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['prefixes' => $prefixes] ]);
    }
    
    public function deleteNamePrefix(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-name-prefix')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = NamesPrefix::find($id);
        
        if(!empty($exists)){
            NamesPrefix::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // --------------------------------------------------------------------------------------------
    
    
    public function nameSuffix(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-name-suffix')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'suffix' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
            // echo "<pre>";
            // print_r( $request->all());
            // exit();
            
        NamesSuffix::updateOrCreate(
            $update_criteria, 
            [
                'suffix' => $request->suffix,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getNameSuffixes(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $sort = $request->query('sort') ?? 'asc';
        
        $suffixes = NamesSuffix::select(['id', 'suffix', 'icon', 'order_number'])->orderBy('suffix', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['suffixes' => $suffixes] ]);
    }
    
    public function deleteNameSuffix(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-name-suffix')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = NamesSuffix::find($id);
        
        if(!empty($exists)){
            NamesSuffix::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function moveoutReason(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-moveout-reason')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'reason' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
            // echo "<pre>";
            // print_r( $request->all());
            // exit();
            
        MoveoutReason::updateOrCreate(
            $update_criteria, 
            [
                'reason' => $request->reason,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getMoveoutReasons(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $sort = $request->query('sort') ?? 'asc';
        
        $reasons = MoveoutReason::select(['id', 'reason', 'icon', 'order_number'])->orderBy('reason', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['reasons' => $reasons] ]);
    }
    
    public function deleteMoveoutReason(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-moveout-reason')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = MoveoutReason::find($id);
        
        if(!empty($exists)){
            MoveoutReason::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function ethnicity(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-ethnicity')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'ethnicity' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
            // echo "<pre>";
            // print_r( $request->all());
            // exit();
            
        Ethnicity::updateOrCreate(
            $update_criteria, 
            [
                'ethnicity' => $request->ethnicity,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getEthnicities(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $sort = $request->query('sort') ?? 'asc';
        
        $ethnicities = Ethnicity::select(['id', 'ethnicity', 'icon', 'order_number'])->orderBy('ethnicity', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['ethnicities' => $ethnicities] ]);
    }
    
    public function deleteEthnicity(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-ethnicity')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = Ethnicity::find($id);
        
        if(!empty($exists)){
            Ethnicity::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function numberType(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-number-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'icon' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        NumbersType::updateOrCreate(
            $update_criteria, 
            [
                'type' => $request->type,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
                
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getNumberTypes(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $sort = $request->query('sort') ?? 'asc';
        
        $number_types = NumbersType::select(['id', 'type', 'icon', 'order_number'])->orderBy('type', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['number_types' => $number_types] ]);
    }
    
    public function deleteNumberType(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-number-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = NumbersType::find($id);
        
        if(!empty($exists)){
            NumbersType::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function allowedPictureType(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-allowed-picture-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'icon' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        AllowedPicturesType::updateOrCreate(
            $update_criteria, 
            [
                'type' => $request->type,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getAllowedPicturesTypes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $allowed_pictures_types = AllowedPicturesType::select(['id', 'type', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['allowed_pictures_types' => $allowed_pictures_types] ]);
    }
    
    public function deleteAllowedPictureType(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-allowed-picture-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = AllowedPicturesType::find($id);
        
        if(!empty($exists)){
            AllowedPicturesType::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function allowedFileType(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-allowed-file-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'type' => 'required',
            'icon' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        AllowedFilesType::updateOrCreate(
            $update_criteria, 
            [
                'type' => $request->type,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getAllowedFilesTypes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $allowed_files_types = AllowedFilesType::select(['id', 'type', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['allowed_files_types' => $allowed_files_types] ]);
    }
    
    public function deleteAllowedFileType(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-allowed-file-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = AllowedFilesType::find($id);
        
        if(!empty($exists)){
            AllowedFilesType::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function nearby(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-nearby')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'icon' => 'required',
            'order_number' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        Nearby::updateOrCreate(
            $update_criteria, 
            [
                'name' => $request->name,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
                'created_by' => $user_id
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getNearbys()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $nearbys = Nearby::select(['id', 'name', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['nearbys' => $nearbys] ]);
    }
    
    public function deleteNearby(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-nearby')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = Nearby::find($id);
        
        if(!empty($exists)){
            Nearby::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function materialSellingUnit(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-material-selling-unit')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'unit' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        MaterialsSellingsUnit::updateOrCreate(
            $update_criteria, 
            [
                'unit' => $request->unit,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getMaterialSellingUnits()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $units = MaterialsSellingsUnit::select(['id', 'unit', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['units' => $units] ]);
    }
    
    public function deleteMaterialSellingUnit(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-material-selling-unit')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = MaterialsSellingsUnit::find($id);
        
        if(!empty($exists)){
            MaterialsSellingsUnit::find($id)->delete();
        }
        
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function materialCoverageUnit(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-material-coverage-unit')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'unit' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        MaterialsCoverageUnit::updateOrCreate(
            $update_criteria, 
            [
                'unit' => $request->unit,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getMaterialCoverageUnits()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $units = MaterialsCoverageUnit::select(['id', 'unit', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['units' => $units] ]);
    }
    
    public function deleteMaterialCoverageUnit(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-material-coverage-unit')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = MaterialsCoverageUnit::find($id);
        
        if(!empty($exists)){
            MaterialsCoverageUnit::find($id)->delete();
        }
        
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function materialUnitSoldBy(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('material-unit-sold-by')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'sold_by' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        MaterialsUnitsSoldBy::updateOrCreate(
            $update_criteria,
            [
                'sold_by' => $request->sold_by
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);

    }
    
    public function getMaterialUnitsSoldBys(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $materials_identifiers = MaterialsUnitsSoldBy::get();

        
        return response()->json(['message' => 'Success', 'data'=> $materials_identifiers ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function changelogCategory(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-changelog-category')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'category' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        ChangelogsCategory::updateOrCreate(
            $update_criteria, 
            [
                'category' => $request->category,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getChangelogCategories()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $categories = ChangelogsCategory::select(['id', 'category', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['categories' => $categories] ]);
    }
    
    public function deleteChangelogCategory(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-changelog-category')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = ChangelogsCategory::find($id);
        
        if(!empty($exists)){
            ChangelogsCategory::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function generalIcon(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-general-icon')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'icon' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        GeneralsIcon::updateOrCreate(
            $update_criteria, 
            [
                'icon' => $request->icon,
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getGeneralIcons()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $icons = GeneralsIcon::select(['id', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['icons' => $icons] ]);
    }
    
    public function deleteGeneralIcon(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-general-icon')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = GeneralsIcon::find($id);
        
        if(!empty($exists)){
            GeneralsIcon::find($id)->delete();
        }
        
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function evictionReason(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-eviction-reason')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'reason' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        EvictionsReason::updateOrCreate(
            $update_criteria, 
            [
                'reason' => $request->reason,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getEvictionReasons(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $sort = $request->query('sort') ?? 'asc';
        
        $reasons = EvictionsReason::select(['id', 'reason', 'icon', 'order_number'])->orderBy('reason', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['reasons' => $reasons] ]);
    }
    
    public function deleteEvictionReason(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-eviction-reason')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = EvictionsReason::find($id);
        
        if(!empty($exists)){
            EvictionsReason::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function websiteSettings(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('update-website-settings')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $data = [
            'website_name' => $request->website_name,
            'max_image_upload_size' => $request->max_image_upload_size,
            'max_file_upload_size' => $request->max_file_upload_size
        ];
        
        WebsiteSetting::where(['id'=>1])->update($data);
        
        return response()->json(['message' => 'Updated Successfully']);

    }
    
    public function getWebsiteSettings()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $settings = WebsiteSetting::where(['id'=>1])->first();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['settings' => $settings] ]);
    }
    
    // -------------------------------------------------------------------------------------
    
    public function vendorCategory(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-vendor-category')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'category' => 'required',
            'for_customers_or_admins' => 'required|numeric'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        VendorsCategory::updateOrCreate(
            $update_criteria, 
            [
                'category' => $request->category,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
                'for_customers_or_admins' => $request->for_customers_or_admins,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getVendorCategoriesForCustomer()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $categories = VendorsCategory::select(['id', 'category', 'icon', 'order_number', 'for_customers_or_admins'])->where(['for_customers_or_admins'=>1])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['categories' => $categories] ]);
    }
    
    public function getVendorCategoriesForAdmins()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $categories = VendorsCategory::select(['id', 'category', 'icon', 'order_number', 'for_customers_or_admins'])->where(['for_customers_or_admins'=>2])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['categories' => $categories] ]);
    }
    
    public function deleteVendorCategory(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-vendor-category')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = VendorsCategory::find($id);
        
        if(!empty($exists)){
            VendorsCategory::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function feature(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-feature')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'feature' => 'required',
            'for_properties_or_units' => 'required|numeric'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        Feature::updateOrCreate(
            $update_criteria,
            [
                'feature' => $request->feature,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0,
                'for_properties_or_units' => $request->for_properties_or_units,
                'created_by' => $user_id,
                'webiste_id' => $this->website_id
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getFeaturesForProperties()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $features = Feature::select(['id', 'feature', 'icon', 'order_number', 'for_properties_or_units'])->where(['for_properties_or_units'=>1])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['features' => $features] ]);
    }
    
    public function getFeaturesForUnits()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $features = Feature::select(['id', 'feature', 'icon', 'order_number', 'for_properties_or_units'])->where(['for_properties_or_units'=>2])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['features' => $features] ]);
    }
    
    public function deleteFeature(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-feature')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = Feature::find($id);
        
        if(!empty($exists)){
            Feature::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function propertyType(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-property-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'type' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        AllPropertiesType::updateOrCreate(
            $update_criteria,
            [
                'type' => $request->type,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getPropertyTypes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $types = AllPropertiesType::select(['id', 'type', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['types' => $types] ]);
    }
    
    public function deletePropertyType(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-property-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = AllPropertiesType::find($id);
        
        if(!empty($exists)){
            AllPropertiesType::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------------
    
    public function unitType(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-unit-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'type' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        AllUnitsType::updateOrCreate(
            $update_criteria,
            [
                'type' => $request->type,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getUnitTypes()
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $types = AllUnitsType::select(['id', 'type', 'icon', 'order_number'])->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['types' => $types] ]);
    }
    
    public function deleteUnitType(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-unit-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = AllUnitsType::find($id);
        
        if(!empty($exists)){
            AllUnitsType::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------
    // ------------------- Counties related functions start --------------------------
    // -------------------------------------------------------------------------------
    
    public function country(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-country')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'country' => 'required',
            'country_code' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        Country::updateOrCreate(
            $update_criteria,
            [
                'country' => $request->country,
                'country_code' => strtoupper($request->country_code),
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getCountries(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $sort = $request->query('sort') ?? 'asc';
        
        $countries = Country::select(['id', 'country', 'country_code', 'icon', 'order_number'])->orderBy('country', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['countries' => $countries] ]);
    }
    
    public function getCountry(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $id = $request->query('id');
        
        $country = Country::select(['id', 'country', 'country_code', 'icon', 'order_number'])->where(['id'=>$id])->first();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['country' => $country] ]);
    }
    
    public function deleteCountry(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-country')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = Country::find($id);
        
        if(!empty($exists)){
            Country::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    public function state(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-state')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'state' => 'required',
            'state_code' => 'required',
            'country_id' => 'required|numeric',
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        State::updateOrCreate(
            $update_criteria,
            [
                'state' => $request->state,
                'state_code' => strtoupper($request->state_code),
                'country_id' => $request->country_id,
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getStates(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $country_id = $request->query('country_id');
        $sort = $request->query('sort') ?? 'asc';
        
        $states = State::select(['id', 'state', 'state_code', 'country_id', 'icon', 'order_number'])->where(['country_id'=>$country_id])->orderBy('state', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['states' => $states] ]);
    }
    
    public function getState(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $id = $request->query('id');
        
        $state = State::select(['id', 'state', 'state_code', 'country_id', 'icon', 'order_number'])->where(['id'=>$id])->first();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['state' => $state] ]);
    }
    
    public function deleteState(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-state')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = State::find($id);
        
        if(!empty($exists)){
            State::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    public function city(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-city')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'city' => 'required',
            'state_code' => 'required',
            'zip_code' => 'required',
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        City::updateOrCreate(
            $update_criteria,
            [
                'city' => $request->city,
                'state_code' => strtoupper($request->state_code),
                'zip_code' => $request->zip_code,
                'latitude' => $request->latitude ?? '',
                'longitude' => $request->longitude ?? '',
                'county' => $request->county ?? '',
                'icon' => $request->icon ?? '',
                'order_number' => $request->order_number ?? 0
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getCities(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $state_code = $request->query('state_code');
        $sort = $request->query('sort') ?? 'asc';
        
        $cities = City::select(['id', 'city', 'state_code', 'zip_code', 'icon', 'order_number'])->where(['state_code'=>$state_code])->orderBy('city', $sort)->get()->unique('city')->toArray();
        
        $cities = array_values($cities);
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['cities' => $cities] ]);
    }
    
    public function getCity(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $id = $request->query('id');
        
        $city = City::select(['id', 'city', 'state_code', 'zip_code', 'icon', 'order_number'])->where(['id'=>$id])->first();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['city' => $city] ]);
    }
    
    public function deleteCity(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-city')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = City::find($id);
        
        if(!empty($exists)){
            City::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    public function searchCities(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $term = $request->query('term');
        
        $cities = City::select(['id', 'city', 'state_code', 'zip_code', 'icon', 'order_number'])->where('city', 'LIKE', '%'.$term.'%')->limit(5)->get()->unique('city')->toArray();
        
        $cities = array_values($cities);
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['$cities' => $cities] ]);
    }
    
    public function getCitiesByIds(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $ids = $request->ids;
        
        $cities = City::select(['id', 'city', 'state_code', 'zip_code', 'icon', 'order_number'])->whereIn('id', $ids)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['cities' => $cities] ]);
    }
    
    // -------------------------------------------------------------------------------
    // -------------------- Counties related functions end ---------------------------
    // -------------------------------------------------------------------------------
    
    // -------------------------------------------------------------------------------
    // ------------------- Vechicles related functions start -------------------------
    // -------------------------------------------------------------------------------
    
    public function vehicleMake(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-vehicle-make')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'make' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        VehiclesMake::updateOrCreate(
            $update_criteria,
            [
                'make' => $request->make
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getVehiclesMakes(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $id = $request->query('id');
        
        $sort = $request->query('sort') ?? 'asc';
        
        $makes = VehiclesMake::select(['id', 'make'])->orderBy('make', $sort)->get();
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['makes' => $makes] ]);
    }
    
    public function deleteVehicleMake(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-vehicle-make')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = VehiclesMake::find($id);
        
        if(!empty($exists)){
            VehiclesMake::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    public function vehicleModel(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('add-edit-vehicle-model')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'model' => 'required',
            'year' => 'required',
            'vehicle_make_id' => 'required|numeric'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
            
        VehiclesModel::updateOrCreate(
            $update_criteria,
            [
                'model' => $request->model,
                'year' => $request->year,
                'vehicle_make_id' => $request->vehicle_make_id,
            ]
        );
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
    public function getVehiclesModels(Request $request)
    {
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(empty($user_id)){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $vehicle_make_id = $request->query('vehicle_make_id');
        $sort = $request->query('sort') ?? 'asc';
        
        $models = VehiclesModel::select(['id', 'model', 'year', 'vehicle_make_id'])->where(['vehicle_make_id' => $vehicle_make_id])->orderBy('model', $sort)->get()->unique('model')->toArray();
        
        $models = array_values($models);
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['models' => $models] ]);
    }
    
    public function deleteVehicleModel(Request $request){

        // check if permission to do
        if(!User::checkPermission('delete-vehicle-model')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $id = $request->query('id');
        $exists = VehiclesModel::find($id);
        
        if(!empty($exists)){
            VehiclesModel::find($id)->delete();
        }
        
        return response()->json(['message' => 'Deleted', 'data'=> [] ]);

    }
    
    // -------------------------------------------------------------------------------
    // -------------------- Vechicles related functions end --------------------------
    // -------------------------------------------------------------------------------
    
    public function rearrangeAdminSettingsLists(Request $request){
        
        $user_id = auth()->user()->id;
        
        // check if permission to do
        if(!User::checkPermission('rearrange-admin-settings-lists')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'identifier' => 'required',
            'data' => 'required'
        ]);
        
        if ($validator->fails()) { 
            return response()->json($validator->errors(), 400);
        }
        
        $identifier = $request->identifier;
        $data = $request->data;
            
        foreach($data as $d){
            $id = $d['id'];
            $order_number = $d['order_number'];
            DB::table($identifier)->where(['id'=>$id])->update(['order_number'=>$order_number]);
        }
        
        return response()->json(['message' => 'Added Successfully']);

    }
    
}