<?php

use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'auth', 'namespace' => 'Api'], function () {

    Route::post('register',     'UsersController@register');

    /* ------------------------ For Personal Access Token ----------------------- */
    Route::post('login',        'UsersController@login');
    /* -------------------------------------------------------------------------- */
    
    /* ----------------------- Social Logins ------------------------------------ */
    Route::get('{driver}/social-login', 'UsersController@socialLogin');
    
    

    Route::group(['middleware' => 'auth:api'], function () {
            
        Route::get('logout',    'UsersController@logout');
        Route::get('user',      'UsersController@getUser');
        
        /* -------------------------- Impersonation --------------------------------- */
        Route::post('impersonation',  'UsersController@impersonation');
        
        // user roles
        Route::get('get-all-roles', 'UsersController@getAllRoles');
        
        
        // permissions
        Route::get('get-all-permissions', 'PermissionsController@getAllPermissions');
        Route::get('get-all-permissions-by-role', 'PermissionsController@getAllPermissionsByRole');
        Route::post('assign-permission-to-role', 'PermissionsController@assignPermissionToRole');
        Route::post('take-permission-from-role', 'PermissionsController@takePermissionFromRole');
        Route::post('assign-delegate-permission-to-user', 'PermissionsController@assignDelegatePermissionToUser');
        Route::post('take-delegate-permission-from-user', 'PermissionsController@TakeDelegatePermissionFromUser');
        Route::get('get-all-permissions-by-user', 'PermissionsController@getAllPermissionsByUser');
        
        
        // features
        Route::post('feature', 'FeaturesController@feature');
        Route::get('get-all-features', 'FeaturesController@getAllFeatures');
        
        // utilities
        Route::post('utility', 'UtilitiesController@utility');
        Route::get('get-all-utilities', 'UtilitiesController@getAllUtilities');
        
        // owner settings
        Route::get('get-current-owner-settings', 'OwnersController@getCurrentOwnerSettings');
        Route::post('set-current-owner-settings', 'OwnersController@setCurrentOwnerSettings');
        
        Route::post('add-my-pets-type', 'OwnersController@addMyPetsType');
        Route::get('get-my-pets-types', 'OwnersController@getMyPetsTypes');
        
        
        // timezones
        Route::get('get-timezones', 'GeneralsController@getTimezones');
        
        
        
        // upload image
        Route::post('upload-image', 'UploadsController@uploadImage');
        
        // upload file
        Route::post('upload-file', 'UploadsController@uploadFile');


        // properties
        Route::get('get-all-properties-types', 'PropertiesController@getAllPropertiesTypes');
        Route::post('property', 'PropertiesController@property');
        Route::get('get-property', 'PropertiesController@getProperty');
        Route::get('get-my-properties', 'PropertiesController@getMyProperties');
        Route::delete('delete-property', 'PropertiesController@deleteProperty');
        Route::post('delete-properties', 'PropertiesController@deleteProperties');
        Route::post('mark-properties-as-active', 'PropertiesController@markPropertiesAsActive');
        Route::post('mark-properties-as-inactive', 'PropertiesController@markPropertiesAsInactive');
        Route::post('duplicate-property', 'PropertiesController@duplicateProperty');
        Route::post('rearrange-property-boards', 'PropertiesController@rearrangePropertyBoards');
        
        // property parking spaces
        // Route::post('property-parking-space', 'PropertiesController@propertyParkingSpace');
        // Route::get('get-property-parking-space', 'PropertiesController@getPropertyParkingSpace');
        Route::get('get-parking-spaces-by-property', 'PropertiesController@getParkingSpacesByProperty');
        Route::post('bulk-unassign-parking-spaces', 'PropertiesController@bulkUnassignParkingSpaces');
        Route::get('get-parking-space-history', 'PropertiesController@getParkingSpaceHistory'); 
        Route::post('assign-single-parking-space', 'PropertiesController@assignSingleParkingSpace');
        
        
        // property materials
        Route::post('property-material', 'PropertiesController@propertyMaterial');
        
        Route::post('property-material-picture', 'PropertiesController@propertyMaterialPicture');
        Route::delete('delete-property-material-picture', 'PropertiesController@deletePropertyMaterialPicture');
        
        Route::post('property-material-file', 'PropertiesController@propertyMaterialFile');
        Route::delete('delete-property-material-file', 'PropertiesController@deletePropertyMaterialFile');
        
        
        // properties locations
        Route::post('properties-location', 'MaterialsMeasurementsController@propertiesLocation');
        Route::get('get-properties-locations', 'MaterialsMeasurementsController@getPropertiesLocations');
        
        
        // property hoa files
        Route::post('property-hoa-file', 'PropertiesController@propertyHoaFile');
        Route::delete('delete-property-hoa-file', 'PropertiesController@deletePropertyHoaFile');
        
        // pictures templates - folders
        Route::get('get-picture-template', 'PicturesTemplatesController@getPictureTemplate');
        Route::get('get-my-pictures-templates', 'PicturesTemplatesController@getMyPicturesTemplates');
        Route::post('picture-template', 'PicturesTemplatesController@pictureTemplate');
        Route::post('picture-template-folder', 'PicturesTemplatesController@pictureTemplateFolder');
        Route::get('get-picture-template', 'PicturesTemplatesController@getPictureTemplate');
        Route::post('duplicate-picture-template', 'PicturesTemplatesController@duplicatePictureTemplate');
        Route::delete('delete-picture-template', 'PicturesTemplatesController@deletePictureTemplate');
        Route::delete('delete-picture-template-folder', 'PicturesTemplatesController@deletePictureTemplateFolder');
        
        // files templates - folders
        Route::get('get-file-template', 'FilesTemplatesController@getFileTemplate');
        Route::get('get-my-files-templates', 'FilesTemplatesController@getMyFilesTemplates');
        Route::post('file-template', 'FilesTemplatesController@fileTemplate');
        Route::post('file-template-folder', 'FilesTemplatesController@fileTemplateFolder');
        Route::get('get-file-template', 'FilesTemplatesController@getFileTemplate');
        Route::post('duplicate-file-template', 'FilesTemplatesController@duplicateFileTemplate');
        Route::delete('delete-file-template', 'FilesTemplatesController@deleteFileTemplate');
        Route::delete('delete-file-template-folder', 'FilesTemplatesController@deleteFileTemplateFolder');
        
        // measurements units
        Route::get('get-measurements-units', 'PropertiesController@getMeasurementsUnits');
        
        
        // units
        Route::get('get-all-units-types', 'UnitsController@getAllUnitsTypes');
        Route::get('get-units-statuses', 'UnitsController@getUnitsStatuses');
        Route::post('unit', 'UnitsController@unit');
        Route::get('get-unit', 'UnitsController@getUnit');
        Route::get('get-my-units', 'UnitsController@getMyUnits');
        Route::delete('delete-unit', 'UnitsController@deleteUnit');
        Route::post('delete-units', 'UnitsController@deleteUnits');
        Route::post('mark-units-as-active', 'UnitsController@markUnitsAsActive');
        Route::post('mark-units-as-inactive', 'UnitsController@markUnitsAsInactive');
        Route::post('duplicate-unit', 'UnitsController@duplicateUnit');
        Route::post('inline-change-unit-name', 'UnitsController@inlineChangeUnitName');
        Route::post('rearrange-unit-boards', 'UnitsController@rearrangeUnitBoards');
        
        // unit materials
        Route::post('units-location', 'MaterialsMeasurementsController@unitsLocation');
        Route::get('get-units-locations', 'MaterialsMeasurementsController@getUnitsLocations');
        
        // materails - measurements - properties - units
        Route::post('material-type', 'MaterialsMeasurementsController@materialType');
        Route::get('get-material-types', 'MaterialsMeasurementsController@getMaterialTypes');
        Route::post('material-brand', 'MaterialsMeasurementsController@materialBrand');
        Route::get('get-material-brands', 'MaterialsMeasurementsController@getMaterialBrands');
        Route::post('material-identifier', 'MaterialsMeasurementsController@materialIdentifier');
        Route::get('get-material-identifiers', 'MaterialsMeasurementsController@getMaterialIdentifiers');
        Route::post('measurement-type', 'MaterialsMeasurementsController@measurementType');
        Route::get('get-measurement-types', 'MaterialsMeasurementsController@getMeasurementTypes');
        
        // Assets Commons
        Route::get('get-assets-assignees-users-types', 'AssetsController@getAssetsAssigneesUsersTypes');
        
        // Assets Keys
        Route::post('key', 'AssetsController@key');
        Route::get('get-key', 'AssetsController@getKey');
        Route::get('get-my-keys', 'AssetsController@getMyKeys');
        Route::post('add-key-quantity', 'AssetsController@addKeyQuantity');
        Route::delete('delete-key', 'AssetsController@deleteKey');
        
        // Assets Loanable Items
        Route::post('loanable-item', 'AssetsController@loanableItem');
        Route::get('get-loanable-item', 'AssetsController@getLoanableItem');
        Route::get('get-my-loanable-items', 'AssetsController@getMyLoanableItems');
        Route::post('add-loanable-item-quantity', 'AssetsController@addLoanableItemQuantity');
        Route::delete('delete-loanable-item', 'AssetsController@deleteLoanableItem');
        Route::post('add-loanable-item-serial-number', 'AssetsController@addLoanableItemSerialNumber');

        
        // generals
        Route::get('get-genders-preferences', 'GeneralsController@getGendersPreferences');
        Route::get('get-genders', 'GeneralsController@getGenders');
        Route::get('get-users-relationships', 'GeneralsController@getUsersRelationships');
        Route::get('get-interactions-types', 'GeneralsController@getInteractionsTypes');
        Route::get('get-vehicles-makes', 'GeneralsController@getVehiclesMakes');
        Route::get('get-vehicles-models', 'GeneralsController@getVehiclesModels');
        Route::get('get-pets-genders', 'GeneralsController@getPetsGenders');
        Route::get('get-users-references-relationships', 'GeneralsController@getUsersReferencesRelationships');
        Route::get('get-places-withs', 'GeneralsController@getPlacesWiths');
        Route::get('get-smoking-permissions', 'GeneralsController@getSmokingPermissions');
        
        
        // Administrator
        Route::post('rearrange-admin-settings-lists', 'AdminsController@rearrangeAdminSettingsLists');
        
        Route::post('parking-space-prefix', 'AdminsController@parkingSpacePrefix');
        Route::get('get-parking-space-prefixes', 'AdminsController@getParkingSpacePrefixes');
        Route::delete('delete-parking-space-prefix', 'AdminsController@deleteParkingSpacePrefix');
        
        Route::post('parking-space-suffix', 'AdminsController@parkingSpaceSuffix');
        Route::get('get-parking-space-suffixes', 'AdminsController@getParkingSpaceSuffixes');
        Route::delete('delete-parking-space-suffix', 'AdminsController@deleteParkingSpaceSuffix');
        
        Route::post('name-prefix', 'AdminsController@namePrefix');
        Route::get('get-name-prefixes', 'AdminsController@getNamePrefixes');
        Route::delete('delete-name-prefix', 'AdminsController@deleteNamePrefix');
        
        Route::post('name-suffix', 'AdminsController@nameSuffix');
        Route::get('get-name-suffixes', 'AdminsController@getNameSuffixes');
        Route::delete('delete-name-suffix', 'AdminsController@deleteNameSuffix');
        
        Route::post('moveout-reason', 'AdminsController@moveoutReason');
        Route::get('get-moveout-reasons', 'AdminsController@getMoveoutReasons');
        Route::delete('delete-moveout-reason', 'AdminsController@deleteMoveoutReason');
        
        Route::post('ethnicity', 'AdminsController@ethnicity');
        Route::get('get-ethnicities', 'AdminsController@getEthnicities');
        Route::delete('delete-ethnicity', 'AdminsController@deleteEthnicity');
        
        Route::post('number-type', 'AdminsController@numberType');
        Route::get('get-number-types', 'AdminsController@getNumberTypes');
        Route::delete('delete-number-type', 'AdminsController@deleteNumberType');
        
        Route::post('allowed-picture-type', 'AdminsController@allowedPictureType');
        Route::get('get-allowed-pictures-types', 'AdminsController@getAllowedPicturesTypes');
        Route::delete('delete-allowed-picture-type', 'AdminsController@deleteAllowedPictureType');
        
        Route::post('allowed-file-type', 'AdminsController@allowedFileType');
        Route::get('get-allowed-files-types', 'AdminsController@getAllowedFilesTypes');
        Route::delete('delete-allowed-file-type', 'AdminsController@deleteAllowedFileType');
        
        Route::post('nearby', 'AdminsController@nearby');
        Route::get('get-nearbys', 'AdminsController@getNearbys');
        Route::delete('delete-nearby', 'AdminsController@deleteNearby');
        
        Route::post('material-selling-unit', 'AdminsController@materialSellingUnit');
        Route::get('get-material-selling-units', 'AdminsController@getMaterialSellingUnits');
        Route::delete('delete-material-selling-unit', 'AdminsController@deleteMaterialSellingUnit');
        
        Route::post('material-coverage-unit', 'AdminsController@materialCoverageUnit');
        Route::get('get-material-coverage-units', 'AdminsController@getMaterialCoverageUnits');
        Route::delete('delete-material-coverage-unit', 'AdminsController@deleteMaterialCoverageUnit');
        
        Route::post('changelog-category', 'AdminsController@changelogCategory');
        Route::get('get-changelog-categories', 'AdminsController@getChangelogCategories');
        Route::delete('delete-changelog-category', 'AdminsController@deleteChangelogCategory');
        
        Route::post('general-icon', 'AdminsController@generalIcon');
        Route::get('get-general-icons', 'AdminsController@getGeneralIcons');
        Route::delete('delete-general-icon', 'AdminsController@deleteGeneralIcon');
        
        Route::post('eviction-reason', 'AdminsController@evictionReason');
        Route::get('get-eviction-reasons', 'AdminsController@getEvictionReasons');
        Route::delete('delete-eviction-reason', 'AdminsController@deleteEvictionReason');
        
        Route::post('website-settings', 'AdminsController@websiteSettings');
        Route::get('get-website-settings', 'AdminsController@getWebsiteSettings');
        
        Route::post('vendor-category', 'AdminsController@vendorCategory');
        Route::get('get-vendor-categories-for-customers', 'AdminsController@getVendorCategoriesForCustomer');
        Route::get('get-vendor-categories-for-admins', 'AdminsController@getVendorCategoriesForAdmins');
        Route::delete('delete-vendor-category', 'AdminsController@deleteVendorCategory');
        
        Route::post('feature', 'AdminsController@feature');
        Route::get('get-features-for-properties', 'AdminsController@getFeaturesForProperties');
        Route::get('get-features-for-units', 'AdminsController@getFeaturesForUnits');
        Route::delete('delete-feature', 'AdminsController@deleteFeature');
        
        Route::post('property-type', 'AdminsController@propertyType');
        Route::get('get-property-types', 'AdminsController@getPropertyTypes');
        Route::delete('delete-property-type', 'AdminsController@deletePropertyType');
        
        Route::post('unit-type', 'AdminsController@unitType');
        Route::get('get-unit-types', 'AdminsController@getUnitTypes');
        Route::delete('delete-unit-type', 'AdminsController@deleteUnitType');
        
        Route::post('country', 'AdminsController@country');
        Route::get('get-countries', 'AdminsController@getCountries');
        Route::get('get-country', 'AdminsController@getCountry');
        Route::delete('delete-country', 'AdminsController@deleteCountry');
        
        Route::post('state', 'AdminsController@state');
        Route::get('get-states', 'AdminsController@getStates');
        Route::get('get-state', 'AdminsController@getState');
        Route::delete('delete-state', 'AdminsController@deleteState');
        
        Route::post('city', 'AdminsController@city');
        Route::get('get-cities', 'AdminsController@getCities');
        Route::get('get-city', 'AdminsController@getCity');
        Route::delete('delete-city', 'AdminsController@deleteCity');
        Route::get('search-cities', 'AdminsController@searchCities');
        Route::post('get-cities-by-ids', 'AdminsController@getCitiesByIds');
        
        Route::post('vehicle-make', 'AdminsController@vehicleMake');
        Route::get('get-vehicles-makes', 'AdminsController@getVehiclesMakes');
        Route::delete('delete-vehicle-make', 'AdminsController@deleteVehicleMake');
        
        Route::post('vehicle-model', 'AdminsController@vehicleModel');
        Route::get('get-vehicles-models', 'AdminsController@getVehiclesModels');
        Route::delete('delete-vehicle-model', 'AdminsController@deleteVehicleModel');
        
        // tenants
        Route::post('tenant', 'TenantsController@tenant');   // add-edit tenant by owner
        Route::get('get-tenant', 'TenantsController@getTenant');   
        Route::get('get-my-tenants', 'TenantsController@getMyTenants');
        Route::get('get-tenant-history-logs', 'TenantsController@getTenantHistoryLogs');
        Route::post('merge-tenant', 'TenantsController@mergeTenant');
        
        
        // applications
        Route::post('application', 'ApplicationsController@application');
        Route::get('get-applications', 'ApplicationsController@getApplications');
        Route::get('get-application', 'ApplicationsController@getApplication');
        Route::get('get-applications-statuses', 'ApplicationsController@getApplicationsStatuses');
        
        // applications settings
        Route::get('get-applications-settings', 'ApplicationsController@getApplicationsSettings');
        Route::post('application-setting', 'ApplicationsController@applicationSetting');
        
        // application links
        Route::post('application-link', 'ApplicationsController@applicationLink');
        Route::get('get-application-link', 'ApplicationsController@getApplicationLink');
        
        // table preferences
        Route::post('table-preference', 'TablesPreferencesController@tablePreference');
        Route::get('get-table-preferences', 'TablesPreferencesController@getTablePreferences');
        
        // users active - inactive
        Route::post('mark-users-as-active', 'UsersController@markUsersAsActive');
        Route::post('mark-users-as-inactive', 'UsersController@markUsersAsInactive');
        
        // delete users
        Route::post('delete-owners-users', 'UsersController@deleteOwnersUsers');
        
        // ------------------------------------------------------------------------
        // ---------------------  communication start   ---------------------------
        // ------------------------------------------------------------------------
        
        // general
        Route::get('get-recipients-groups', 'EmailsController@getRecipientsGroups');
        Route::get('get-email-tokens', 'EmailsController@getEmailTokens');
        
        // templates
        Route::get('get-my-emails-templates-list', 'EmailsController@getMyEmailsTemplatesList');
        Route::get('get-my-email-template', 'EmailsController@getMyEmailTemplate');
        Route::post('email-template', 'EmailsController@saveEmailTemplate');
        
        // emails
        Route::post('save-email-as-draft', 'EmailsController@saveEmailAsDraft');
        
        // ------------------------------------------------------------------------
        // ----------------------  communication end   ----------------------------
        // ------------------------------------------------------------------------
        
    });

   /* ------------------------ For Password Grant Token ------------------------ */
    Route::post('login_grant',  'UsersController@loginGrant');
    Route::post('refresh',      'UsersController@refreshToken');
    /* -------------------------------------------------------------------------- */
    
    
    
    /* -------------------------------------------------------------------------- */

    /* -------------------------------- Fallback -------------------------------- */
    Route::any('{segment}', function () {
        return response()->json([
            'error' => 'Invalid url.'
        ]);
    })->where('segment', '.*');
});

Route::get('unauthorized', function () {
    return response()->json([
        'error' => 'Unauthorized.'
    ], 401);
})->name('unauthorized');


Route::group(['namespace' => 'Api'], function () {

    Route::get('subscriptions-packages', 'SubscriptionsController@subscriptionsPackages');
    
    
    
    

});
