<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\UnitsNote;

class UnitsNote extends Model
{
    use HasFactory;
    protected $fillable = [
        'unit_id',
        'note',
        'type'
    ];    
    
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        
    ];
    
    public function notes($unit_id){
        return UnitsNote::where(['unit_id'=>$unit_id, 'type'=>'public'])->get();
    }
    
    public function staffNotes($unit_id){
        return UnitsNote::where(['unit_id'=>$unit_id, 'type'=>'staff'])->get();
    }
    
    public function managerNotes($unit_id){
        return UnitsNote::where(['unit_id'=>$unit_id, 'type'=>'manager'])->get();
    }
    
    public function ownerNotes($unit_id){
        return UnitsNote::where(['unit_id'=>$unit_id, 'type'=>'owner'])->get();
    }
    
}
