<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\UnitsMaterialsPicture;
use App\Models\UnitsMaterialsFile;
use App\Models\UnitsMaterial;
use App\Models\Unit;

class UnitsMaterial extends Model
{
    use HasFactory;
    protected $fillable = [
        'unit_id',
        'name',
        'material_type_id',
        'unit_location_id',
        'material_brand_id',
        'color',
        'material_identifier_id',
        'material_vendor_id',
        'last_installed',
        'last_purchased',
        'amount',
        'price',
        'coverage',
        'material_on_hand',
        'coverage_on_hand',
        'storage_location',
        'notes'
    ];    
    
    public static function getUnitMaterials($unit_id){
        
        if(empty($unit_id)){
            return [];
        }
        
        $materials = parent::
            select(
                'units_materials.*',
                'materials_types.type as material_type', 
                'units_locations.location as unit_location', 
                'materials_brands.brand as material_brand',
                'materials_identifiers.identifier as material_identifier'
                )
            ->join('materials_types', 'units_materials.material_type_id', '=', 'materials_types.id')
            ->join('units_locations', 'units_materials.unit_location_id', '=', 'units_locations.id')
            ->join('materials_brands', 'units_materials.material_brand_id', '=', 'materials_brands.id')
            ->join('materials_identifiers', 'units_materials.material_identifier_id', '=', 'materials_identifiers.id')
            ->where(['units_materials.unit_id'=>$unit_id])->get();
            
            
        $materials = (!empty($materials)) ? $materials->toArray() : [];
        
        for($i=0; $i<count($materials); $i++){
            
            $unit_material_id = $materials[$i]['id'];
            
            $pictures = UnitsMaterialsPicture::where(['unit_material_id'=>$unit_material_id])->get();
            $materials[$i]['pictures'] = (!empty($pictures)) ? $pictures->toArray() : [];
            
            $files = UnitsMaterialsFile::where(['unit_material_id'=>$unit_material_id])->get();
            $materials[$i]['files'] = (!empty($files)) ? $files->toArray() : [];
            
        }
        
        return $materials;
        
        
    }
    
    
}
