<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\PropertiesNote;

class PropertiesNote extends Model
{
    use HasFactory;
    protected $fillable = [
        'property_id',
        'note',
        'type'
    ];    
    
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        
    ];
    
    public function notes($property_id){
        return PropertiesNote::where(['property_id'=>$property_id, 'type'=>'public'])->get();
    }
    
    public function staffNotes($property_id){
        return PropertiesNote::where(['property_id'=>$property_id, 'type'=>'staff'])->get();
    }
    
    public function managerNotes($property_id){
        return PropertiesNote::where(['property_id'=>$property_id, 'type'=>'manager'])->get();
    }
    
    public function ownerNotes($property_id){
        return PropertiesNote::where(['property_id'=>$property_id, 'type'=>'owner'])->get();
    }
    
}
