<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

use App\Models\Role;
use App\Models\UsersRole;
use App\Models\User;
use App\Models\Permission;
use App\Models\PermissionsRole;
use App\Models\DelegateUsersPermission;

use Carbon\Carbon;

class PermissionsController extends Controller
{
    
    public function getAllPermissions()
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('get-all-permissions')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $permissions = Permission::select(['id', 'permission', 'description'])->where(['website_id'=>config('constants.website_id')])->get();
        
        $permissions = (!empty($permissions)) ? $permissions->toArray() : [];
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['permissions' => $permissions] ]);
    }
    
    public function getAllPermissionsByRole(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('get-all-permissions-by-role')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $role_id = $request->query('role_id');
        
        $role = Role::find($role_id);

        if (empty($role)) {
            return response()->json(['Invalid Role'], 400);
        }
        
        $permissions = User::getAllPermissionsByRole($role_id);
        
        return response()->json(['message' => 'Success', 'data'=> $permissions ]);
        
        
    }

    public function assignPermissionToRole(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('assign-permission-to-role')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'permission_id' => 'required|numeric',
            'role_id' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        
        // $update_criteria = [];
        // if(!empty($request->id)){
        //     $update_criteria['id'] = $request->id;
        // }
        // else{
        //     $update_criteria['id'] = 0;
        // }
        
        $update_criteria = [];
        
        // check if already exist
        $exists = PermissionsRole::where(['permission_id' => $request->permission_id, 'role_id' => $request->role_id, ])->first();
        
        if(empty($exists)){
            
            PermissionsRole::create(
                //$update_criteria,
                [
                    'permission_id' => $request->permission_id, 
                    'role_id' => $request->role_id, 
                    'created_id' => $user_id
                ]
            );
            
        }
        
        
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);
    }
    
    public function takePermissionFromRole(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('take-permission-from-role')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'permission_id' => 'required|numeric',
            'role_id' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        
        // check if already exist
        $exists = PermissionsRole::where(['permission_id' => $request->permission_id, 'role_id' => $request->role_id, ])->first();
        
        if(!empty($exists)){
            PermissionsRole::where(['permission_id' => $request->permission_id, 'role_id' => $request->role_id, ])->delete();
        }
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);
    }
    
    public function assignDelegatePermissionToUser(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('assign-delegate-permission-to-user')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'permission_id' => 'required|numeric',
            'user_id' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        
        // check if already exist
        $exists = DelegateUsersPermission::where(['permission_id' => $request->permission_id, 'user_id' => $request->user_id, ])->first();
        
        if(!empty($exists)){
            $update_criteria['id'] = $exists->id;
        }
        
        $properties_materials_type = DelegateUsersPermission::updateOrCreate(
            $update_criteria,
            [
                'permission_id' => $request->permission_id, 
                'user_id' => $request->user_id, 
                'granted' => 1,
                'taken' => 0,
                'created_id' => $user_id
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);
    }

    public function takeDelegatePermissionFromUser(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('take-delegate-permission-from-user')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'permission_id' => 'required|numeric',
            'user_id' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        
        // check if already exist
        $exists = DelegateUsersPermission::where(['permission_id' => $request->permission_id, 'user_id' => $request->user_id, ])->first();
        
        if(!empty($exists)){
            $update_criteria['id'] = $exists->id;
        }
        
        $properties_materials_type = DelegateUsersPermission::updateOrCreate(
            $update_criteria,
            [
                'permission_id' => $request->permission_id, 
                'user_id' => $request->user_id, 
                'granted' => 0,
                'taken' => 1,
                'created_id' => $user_id
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
    }
    
    public function getAllPermissionsByUser(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('get-all-permissions-by-user')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $user_id = $request->query('user_id');
        
        $user = User::find($user_id);

        if (empty($user)) {
            return response()->json(['Invalid User'], 400);
        }
        
        $permissions = User::getAllPermissionsByUser($user_id);
        
        return response()->json(['message' => 'Success', 'data'=> $permissions ]);
        
        
    }

}