<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

use App\Models\MaterialsType;
use App\Models\MaterialsBrand;
use App\Models\MaterialsIdentifier;

use App\Models\MeasurementsType;

use App\Models\PropertiesLocation;
use App\Models\UnitsLocation;

use App\Models\UsersRole;
use App\Models\User;
use Carbon\Carbon;

use App\Libraries\Generic;


class MaterialsMeasurementsController extends Controller
{
    
    protected $generic;
    
    public function __construct(){
        
        $this->generic = new Generic();
        
    }
    
    // materials related functions
    
    public function materialType(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('material-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'type' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        MaterialsType::updateOrCreate(
            $update_criteria,
            [
                'type' => $request->type, 
                'owner_id' => $owner_id
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);

    }
    
    public function getMaterialTypes(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-material-types')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $materials_types = MaterialsType::where(['owner_id' => $owner_id])->get();

        
        return response()->json(['message' => 'Success', 'data'=> $materials_types ]);

    }
    
    public function materialBrand(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('material-brand')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'brand' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        MaterialsBrand::updateOrCreate(
            $update_criteria,
            [
                'brand' => $request->brand, 
                'owner_id' => $owner_id
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);

    }
    
    public function getMaterialBrands(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-material-brands')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $materials_brands = MaterialsBrand::where(['owner_id' => $owner_id])->get();

        
        return response()->json(['message' => 'Success', 'data'=> $materials_brands ]);

    }
    
    public function materialIdentifier(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('material-identifier')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'identifier' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        MaterialsIdentifier::updateOrCreate(
            $update_criteria,
            [
                'identifier' => $request->identifier, 
                'owner_id' => $owner_id
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);

    }
    
    public function getMaterialIdentifiers(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-material-identifiers')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $materials_identifiers = MaterialsIdentifier::where(['owner_id' => $user_id])->get();

        
        return response()->json(['message' => 'Success', 'data'=> $materials_identifiers ]);

    }
    
    
    // measurements related functions
    
    public function measurementType(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('measurement-type')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'type' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        MeasurementsType::updateOrCreate(
            $update_criteria,
            [
                'type' => $request->type, 
                'owner_id' => $owner_id
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);

    }
    
    public function getMeasurementTypes(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-measurement-types')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $measurements_types = MeasurementsType::where(['owner_id' => $owner_id])->get();

        
        return response()->json(['message' => 'Success', 'data'=> $measurements_types ]);

    }
    
    public function propertiesLocation(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('properties-location')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'location' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        PropertiesLocation::updateOrCreate(
            $update_criteria,
            [
                'location' => $request->location, 
                'owner_id' => $owner_id
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);

    }
    
    public function getPropertiesLocations(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-properties-locations')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'property_id' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $property_id = $request->property_id;
        
        $properties_locations = PropertiesLocation::where(['owner_id' => $owner_id, 'property_id' => $property_id])->get();

        
        return response()->json(['message' => 'Success', 'data'=> $properties_locations ]);

    }
    
    
    ///////
    
    public function unitsLocation(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('units-location')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'location' => 'required'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        UnitsLocation::updateOrCreate(
            $update_criteria,
            [
                'location' => $request->location, 
                'owner_id' => $owner_id
            ]
        );
        
        return response()->json(['message' => 'Success', 'data'=> [] ]);

    }
    
    public function getUnitsLocations(Request $request){

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('get-units-locations')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'unit_id' => 'required'
        ]);
        
        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $unit_id = $request->unit_id;
        
        $units_locations = UnitsLocation::where(['owner_id' => $owner_id, 'unit_id' => $unit_id])->get();

        
        return response()->json(['message' => 'Success', 'data'=> $units_locations ]);

    }
    


}