<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Laravel\Passport\RefreshTokenRepository;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

use App\Models\Property;
use App\Models\Unit;
use App\Models\User;
use App\Models\Role;
use App\Models\UsersRole;
use App\Models\UsersAddress;
use App\Models\UsersNumber;
use App\Models\UsersProfile;
use App\Models\UsersPicture;
use App\Models\UsersEmergenciesContact;
use App\Models\UsersNotification;
use App\Models\UsersFile;
use App\Models\UsersManagersFile;
use App\Models\UsersOwnersFile;
use App\Models\UsersStaffFile;
use App\Models\UsersInteraction;
use App\Models\UsersInteractionsFile;
use App\Models\UsersVehicle;
use App\Models\UsersVehiclesPicture;
use App\Models\UsersVehiclesFile;
use App\Models\UsersChildren;
use App\Models\UsersChildrensPicture;
use App\Models\UsersChildrensFile;
use App\Models\UsersPet;
use App\Models\UsersPetsShot;
use App\Models\UsersPetsPicture;
use App\Models\UsersPetsFile;
use App\Models\UsersOthersLiving;
use App\Models\UsersOthersLivingsPicture;
use App\Models\UsersOthersLivingsFile;
use App\Models\UsersEmployment;
use App\Models\UsersReference;
use App\Models\UsersPreviousHousing;
use App\Models\Application;
use App\Models\ApplicationsStatus;
use App\Models\ApplicationsCosigner;
use App\Models\ApplicationsFile;
use App\Models\ApplicationsInteraction;
use App\Models\ApplicationsSetting;
use App\Models\ApplicationsLink;

use Carbon\Carbon;
use Exception;
use DB;

use App\Libraries\Generic;

class ApplicationsController extends Controller
{
    
    protected $generic;
    
    public function __construct(){
        
        $this->generic = new Generic();
        
    }

    public function application(Request $request)
    {

        // echo "<pre>";
        // print_r($request->all());
        // exit();
        
        $user_id = auth()->user()->id;
        
        
        // if(!User::checkPermission('add-edit-tenant')){
        //     return response()->json(config('constants.messages.permission_denied'), 400);
        //     exit();
        // }
        
        $prospect_id = (!empty($request->prospect_id)) ? $request->prospect_id : 0;
        $application_id = (!empty($request->id)) ? $request->id : 0;
        
        $validation_rules = [
            'application_link_id' => 'required|numeric|exists:applications_links,id',
            'firstname' => 'required|min:2',
            'lastname' => 'required',
        ];
        
        if(empty($request->id)){
            $validation_rules['email'] = 'required|email|unique:users';
        }
        
        $validator = Validator::make($request->all(), $validation_rules);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        $application_link_id = $request->application_link_id;
        
        $application_link = ApplicationsLink::find($application_link_id);
        
        // get property
        $property_id = $application_link->property_id;
        $property = Property::find($property_id);
        
        $unit_id = $application_link->unit_id;
        
        // first create user if it is first time
        if(empty($application_id)){
            $data = [
                'user_prefix_id' => $request->user_prefix_id ?? null,
                'firstname' => $request->firstname,
                'middlename' => $request->middlename ?? '',
                'lastname' => $request->lastname,
                'user_suffix_id' => $request->user_suffix_id ?? null,
                'uuid' => (string) Str::uuid(),
                'email' => $request->email,
                'password' => null,
                'owner_id' => $property->owner_id,
                'creator_id' => (!empty($user_id)) ? $user_id : null, 
                'website_id' => 1,     // indicate that this user is from property website
            ];
            
            $prospect = User::create($data);
            $prospect_id = $prospect->id;
            
            // set this user role
            UsersRole::create([
                'user_id' => $prospect_id,
                'role_id' => 7,   // prospect
            ]);
            
            // addresses
            $addresses = $request->addresses ?? [];
    
            foreach($addresses as $a){
                
                $update_criteria = [];
                
                UsersAddress::create([
                    'user_id' => $prospect_id,
                    'address_line1' => $a['address_line1'] ?? '',
                    'address_line2' => $a['address_line2'] ?? '',
                    'city' => $a['city'] ?? '',
                    'state' => $a['state'] ?? '',
                    'country' => $a['country'] ?? '',
                    'zip_code' => $a['zip_code'] ?? ''
                ]);
                
            }
            
            // numbers
            $numbers = $request->numbers ?? [];
    
            foreach($numbers as $n){
                
                $update_criteria = [];
                
                UsersNumber::create([
                    'user_id' => $prospect_id,
                    'country_code' => $n['phone_country_code'] ?? '',
                    'phone_number' => $n['phone_number'] ?? '',
                    'number_type' => $n['number_type'] ?? '',
                ]);
                
            }
            
            // user profile
            $update_criteria = [];
            $user = UsersProfile::updateOrCreate(
                $update_criteria,
                [
                    'user_id' => $prospect_id,
                    'enable_portal' => $request->enable_portal ?? 0,
                    'send_notifications' => $request->send_notifications ?? 0,
                    'date_of_birth' => $request->date_of_birth ?? '',
                    'dln_id' => $request->dln_id ?? '',
                    'dl_id_picture' => $request->dl_id_picture ?? '',
                    'dln_id_issue_state' => $request->dln_id_issue_state ?? '',
                    'dln_id_issue_notes' => $request->dln_id_issue_notes ?? '',
                    'gender_id' => $request->gender_id ?? null,
                    'ethnicity_id' => $request->ethnicity_id ?? null,
                    'smoker' => $request->smoker ?? 0,
                    'smoker_notes' => $request->smoker_notes ?? '',
                    'known_allergies' => $request->known_allergies ?? '',
                    'other_emergency_info' => $request->other_emergency_info ?? '',
                    'user_notes' => $request->user_notes ?? '',
                    'user_staff_notes' => $request->user_staff_notes ?? '',
                    'user_manager_notes' => $request->user_manager_notes ?? '',
                    'user_owner_notes' => $request->user_owner_notes ?? '',
                    'moveout_address1' => $request->moveout_address1 ?? '',
                    'moveout_address2' => $request->moveout_address2 ?? '',
                    'moveout_city' => $request->moveout_city ?? '',
                    'moveout_state' => $request->moveout_state ?? '',
                    'moveout_zip_code' => $request->moveout_zip_code ?? '',
                    'moveout_number' => $request->moveout_number ?? '',
                    'moveout_number_type' => $request->moveout_number_type ?? '',
                    'moveout_email' => $request->moveout_email ?? '',
                    'moveout_date' => $request->moveout_date ?? '',
                    'moveout_reason_id' => $request->moveout_reason_id ?? null
                ]
            );
            
            // now create application
            $update_criteria = [];
            $application = Application::updateOrCreate(
                $update_criteria,
                [
                    'property_id' => $property_id,
                    'unit_id' => $unit_id,
                    'application_link_id' => $application_link_id,
                    'user_id' => $prospect_id,
                    'application_status_id' => $request->application_status_id ?? 3,
                    'ever_evicted' => $request->ever_evicted ?? 0,
                    'eviction_notes' => $request->eviction_notes ?? '',
                    'ever_convicted_of_felony' => $request->ever_convicted_of_felony ?? 0,
                    'convicted_of_felony_notes' => $request->convicted_of_felony_notes ?? '',
                    'has_cosigners' => $request->has_cosigners ?? 0,
                    'messy_clean' => $request->messy_clean ?? 0,
                    'loud_quiet' => $request->loud_quiet ?? 0,
                    'extra_fields_json' => $request->extra_fields_json ?? '',
                    'additional_information' => $request->additional_information ?? '',
                    'notes' => $request->notes ?? ''
                ]
            );
            
            $application_id = $application->id;
            
        }
        
        // previous housing 
        $previous_housings = $request->previous_housings ?? [];

        foreach($previous_housings as $p){
            
            $update_criteria = [];
            if(!empty($p['id'])){
                $update_criteria['id'] = $p['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            UsersPreviousHousing::updateOrCreate($update_criteria, [
                'user_id' => $prospect_id,
                'property_name' => $p['property_name']  ?? '',
                'montly_rent' => $p['montly_rent']  ?? 0,
                'address_line1' => $p['address_line1']  ?? '',
                'address_line2' => $p['address_line2']  ?? '',
                'city' => $p['city']  ?? '',
                'state' => $p['state']  ?? '',
                'zip_code' => $p['zip_code']  ?? '',
                'property_manager' => $p['property_manager']  ?? '',
                'number1' => $p['number1']  ?? '',
                'number1_type' => $p['number1_type']  ?? '',
                'number2' => $p['number2']  ?? '',
                'number2_type' => $p['number2_type']  ?? '',
                'email' => $p['email']  ?? '',
                'move_in_date' => $p['move_in_date']  ?? '',
                'move_out_date' => $p['move_out_date']  ?? '',
                'reason_for_moving' => $p['reason_for_moving']  ?? '',
                'housing_notes' => $p['housing_notes']  ?? '',
            ]);
        }
        
        // employments
        $employments = $request->employments ?? [];
        
        foreach($employments as $e){
            
            $update_criteria = [];
            if(!empty($e['id'])){
                $update_criteria['id'] = $e['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            UsersEmployment::updateOrCreate($update_criteria, [
                'company_name' => $e['company_name'] ?? '',
                'position' => $e['position'] ?? '',
                'annual_salary' => $e['annual_salary'] ?? 0,
                'start_year' => $e['start_year'] ?? '',
                'end_year' => $e['end_year'] ?? '',
                'present' => $e['present'] ?? 0,
                'address_line1' => $e['address_line1'] ?? '',
                'address_line2' => $e['address_line2'] ?? '',
                'city' => $e['city'] ?? '',
                'state' => $e['state'] ?? '',
                'zip_code' => $e['zip_code'] ?? '',
                'website' => $e['website'] ?? '',
                'supervisor' => $e['supervisor'] ?? '',
                'number' => $e['number'] ?? '',
                'number_type' => $e['number_type'] ?? '',
                'leaving_reason' => $e['leaving_reason'] ?? '',
                'notes' => $e['notes'] ?? '',
                'user_id' => $prospect_id
            ]);
            
        }
        
        // children
        $childrens = $request->childrens ?? [];

        foreach($childrens as $c){
            
            $update_criteria = [];
            if(!empty($c['id'])){
                $update_criteria['id'] = $c['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $children = UsersChildren::updateOrCreate($update_criteria, [
                'status' => $c['status'] ?? 0,
                'firstname' => $c['firstname'] ?? '',
                'middlename' => $c['middlename'] ?? '',
                'lastname' => $c['lastname'] ?? '',
                'gender_id' => $c['gender_id'] ?? '',
                'date_of_birth' => $c['date_of_birth'] ?? '',
                'public_note' => $c['public_note'] ?? '',
                'private_note' => $c['private_note'] ?? '',
                'user_id' => $prospect_id
            ]);
            
            
        }
        
        // pets
        $pets = $request->pets ?? [];

        foreach($pets as $p){
            
            $update_criteria = [];
            if(!empty($p['id'])){
                $update_criteria['id'] = $p['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $pet = UsersPet::updateOrCreate($update_criteria, [
                'status' => $p['status'] ?? 0,
                'name' => $p['name'] ?? '',
                'pet_type_id' => $p['pet_type_id'] ?? null,
                'pet_gender_id' => $p['pet_gender_id'] ?? null,
                'breed' => $p['breed'] ?? '',
                'color' => $p['color'] ?? '',
                'weight' => $p['weight'] ?? '',
                'date_of_birth' => $p['date_of_birth'] ?? '',
                'support_animal' => $p['support_animal'] ?? 0,
                'deposit' => $p['deposit'] ?? '',
                'rent' => $p['rent'] ?? '',
                'license' => $p['license'] ?? '',
                'location_of_license' => $p['location_of_license'] ?? '',
                'public_note' => $p['public_note'] ?? '',
                'private_note' => $p['private_note'] ?? '',
                'user_id' => $prospect_id
            ]);
            
        }
        
        
        // other livings
        $other_livings = $request->other_livings ?? [];

        foreach($other_livings as $o){
            
            $update_criteria = [];
            if(!empty($o['id'])){
                $update_criteria['id'] = $o['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $other_living = UsersOthersLiving::updateOrCreate($update_criteria, [
                'status' => $o['status'] ?? 0,
                'firstname' => $o['firstname'] ?? '',
                'middlename' => $o['middlename'] ?? '',
                'lastname' => $o['lastname'] ?? '',
                'date_of_birth' => $o['date_of_birth'] ?? '',
                'gender_id' => $o['gender_id'] ?? null,
                'user_relationship_id' => $o['user_relationship_id'] ?? null,
                'other_relationship' => $o['other_relationship'] ?? '',
                'additional_deposit' => $o['additional_deposit'] ?? 0,
                'additional_rent' => $o['additional_rent'] ?? 0,
                'reason_for_movein' => $o['reason_for_movein'] ?? '',
                'public_note' => $o['public_note'] ?? '',
                'private_note' => $o['private_note'] ?? '',
                'user_id' => $prospect_id
            ]);
            
        }
        
        
        // references
        $references = $request->references ?? [];
        
        foreach($references as $r){
            
            $update_criteria = [];
            if(!empty($r['id'])){
                $update_criteria['id'] = $r['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            UsersReference::updateOrCreate($update_criteria, [
                'firstname' => $r['firstname'] ?? '',
                'lastname' => $r['lastname'] ?? '',
                'user_reference_relationship_id' => $r['user_reference_relationship_id'] ?? null,
                'other_reference_relationship' => $r['other_reference_relationship'] ?? '',
                'number1' => $r['number1'] ?? '',
                'number1_type' => $r['number1_type'] ?? '',
                'number2' => $r['number2'] ?? '',
                'number2_type' => $r['number2_type'] ?? '',
                'number3' => $r['number3'] ?? '',
                'number3_type' => $r['number3_type'] ?? '',
                'notes' => $r['notes'] ?? '',
                'user_id' => $prospect_id
            ]);
            
        }
        
        // co signer
        $cosigners = $request->cosigners ?? [];
        
        foreach($cosigners as $r){
            
            $update_criteria = [];
            if(!empty($r['id'])){
                $update_criteria['id'] = $r['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            ApplicationsCosigner::updateOrCreate($update_criteria, [
                'application_id' => $application_id,
                'firstname' => $r['firstname'] ?? '',
                'lastname' => $r['lastname'] ?? '',
                'middlename' => $r['middlename'] ?? '',
                'lastname' => $r['lastname'] ?? '',
                'address_line1' => $r['address_line1'] ?? '',
                'address_line2' => $r['address_line2'] ?? '',
                'city' => $r['city'] ?? '',
                'state' => $r['state'] ?? '',
                'zip_code' => $r['zip_code'] ?? '',
                'number1' => $r['number1'] ?? '',
                'number1_type' => $r['number1_type'] ?? '',
                'number2' => $r['number2'] ?? '',
                'number2_type' => $r['number2_type'] ?? '',
                'email' => $r['email'] ?? '',
                'date_of_birth' => $r['date_of_birth'] ?? '',
                'user_relationship_id' => $r['user_relationship_id'] ?? null,
                'employer' => $r['employer'] ?? '',
                'position' => $r['position'] ?? '',
                'annual_salary' => $r['annual_salary'] ?? ''
            ]);
            
        }
        
        // files
        $files = $request->application_files ?? [];

        foreach($files as $f){
            
            $update_criteria = [];
            if(!empty($f['id'])){
                $update_criteria['id'] = $f['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            ApplicationsFile::updateOrCreate($update_criteria, [
                'application_id' => $application_id,
                'file' => $f['file'],
            ]);
            
        }
        
        // interactions
        $interactions = $request->interactions ?? [];

        foreach($interactions as $i){
            
            $update_criteria = [];
            if(!empty($i['id'])){
                $update_criteria['id'] = $i['id'];
            }
            else{
                $update_criteria['id'] = 0;
            }
            
            $date = (!empty($i['date'])) ? $this->generic->formatInputDate($i['date']) : date('d-m-Y');
            $time = $i['time'] ?? date('h:m:i A');
            
            ApplicationsInteraction::updateOrCreate($update_criteria, [
                'application_id' => $application_id,
                'date' => $date,
                'time' => $time,
                'interaction_type_id' => $i['interaction_type_id'] ?? null,
                'other_type_description' => $i['other_type_description'] ?? '',
                'notes' => $i['notes'] ?? '',
                'who_meet_user_id' => $i['who_meet_user_id'] ?? null,
            ]);
            
        }
        
        return response()->json(['message' => 'success']);
        
    }
    
    public function getApplicationsStatuses()
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $statuses = ApplicationsStatus::all();
                
        return response()->json(['data' => $statuses]);
        
    }
    
    public function getApplications(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('get-applications')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $property_id = $request->query('property_id');
        $property = Property::find($property_id);
        
        // check if property exists
        if(empty($property)){
            return response()->json(['message' => 'No property found']);
        }
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }

        // gets units details
        $units = Unit::select(['id', 'name', 'is_active', 'monthly_rent', 'security_deposit'])->where(['property_id'=>$property_id])->get();
        
        // get submitted applications details
        $applications = DB::table('applications')
                        ->leftjoin('users', 'users.id', '=', 'applications.user_id')
                        ->leftJoin('users_employments', 'users_employments.user_id', '=', 'applications.user_id')
                        ->leftjoin('users_childrens', 'users_childrens.user_id', '=', 'applications.user_id')
                        ->leftJoin('users_pets', 'users_pets.user_id', '=', 'applications.user_id')
                        ->leftJoin('users_others_livings', 'users_others_livings.user_id', '=', 'applications.user_id')
                        ->select('applications.id', 'applications.unit_id', 'applications.application_status_id', 'applications.has_cosigners', 'applications.created_at', 'applications.updated_at', 'users.firstname', 'users.lastname', 'users_employments.position', 'users_employments.supervisor', 'users_employments.annual_salary', 'users_childrens.id as children_id', 'users_pets.id as pet_id', 'users_others_livings.id as other_living_id')
                        ->where(['applications.property_id'=>$property_id])
                        ->get();
                
        $data = [
            'units' => $units,
            'applications' => $applications,
        ];
                
        return response()->json(['data' => $data]);
        
    }
    
    public function getApplication(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        // check if permission to do
        if(!User::checkPermission('get-application')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $application_id = $request->query('application_id');
        $application = Application::find($application_id);
        
        // check if application exists
        if(empty($application)){
            return response()->json(['message' => 'No Application found']);
        }
        
        $property_id = $application->property_id;
        
        $property = Property::find($property_id);
        
        // check if have access to view or edit
        if($property->owner_id != $owner_id){
            return response()->json(config('constants.messages.invalid_access'), 400);
            exit();
        }

        $application = $application->toArray();
        $user_id = $application['user_id'];

        $application['user'] =    User::select(['firstname', 'middlename', 'lastname', 'email'])->where(['id' => $user_id])->get();
        $application['addresses'] =    User::find($user_id)->addresses;
        $application['numbers'] =    User::find($user_id)->phoneNumbers;
        $application['profile'] =    User::find($user_id)->profile;
        $application['childrens'] =    User::children($user_id);
        $application['pets'] =    User::pets($user_id);
        $application['other_livings'] =    User::otherLivings($user_id);
        $application['employments'] =    User::find($user_id)->employments;
        $application['references'] =    User::find($user_id)->references;
        $application['previous_housings'] =    User::find($user_id)->previousHousings;
        $application['cosigners'] =    Application::find($application_id)->cosigners;
        $application['files'] =    Application::find($application_id)->files;
        $application['interactions'] =    Application::find($application_id)->interactions;
        
        
        return response()->json(['data' => $application]);
        
    }
    
    // ---------------------------------------------------------------------------------------
    // --------------------------  General Settings Start  -----------------------------------
    // ---------------------------------------------------------------------------------------
    
    public function applicationSetting(Request $request){
        
        // echo "<pre>";
        // print_r($request->all());
        // exit();

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('add-edit-application-setting')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'owner_id' => 'required|numeric',
            'previous_housings_years' => 'required|numeric|min:1|max:50',
            'employers_years' => 'required|min:1|max:50',
            'minimum_references' => 'required|min:0|max:50'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        $update_criteria = [];
        if(!empty($request->owner_id)){
            $update_criteria['owner_id'] = $request->owner_id;
        }
        else{
            $update_criteria['owner_id'] = 0;
        }
        
            // echo "<pre>";
            // print_r( $request->all());
            // exit();

        ApplicationsSetting::updateOrCreate(
            $update_criteria, 
            [
                'owner_id' => $request->owner_id,
                'previous_housings_years' => $request->previous_housings_years,
                'employers_years' => $request->employers_years,
                'minimum_references' => $request->minimum_references,
                'additional_information' => $request->additional_information,
            ]
        );

        return response()->json(['message' => 'success']);

    }
    
    public function getApplicationsSettings(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $settings = ApplicationsSetting::where(['owner_id'=>$owner_id])->get();
        
        return response()->json(['data' => $settings]);
        
    }
    
    // ---------------------------------------------------------------------------------------
    // ----------------------------  General Settings End  -----------------------------------
    // ---------------------------------------------------------------------------------------
    
    
    // ---------------------------------------------------------------------------------------
    // ----------------------------  General Links Start  ------------------------------------
    // ---------------------------------------------------------------------------------------
    
    public function applicationLink(Request $request){
        
        // echo "<pre>";
        // print_r($request->all());
        // exit();

        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);

        // check if permission to do
        if(!User::checkPermission('add-edit-application-setting')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $validator = Validator::make($request->all(), [
            'property_id' => 'required|numeric|exists:properties,id',
            'unit_id' => 'required|numeric|exists:units,id',
            'previous_housings_years' => 'required|numeric|min:1|max:50',
            'employers_years' => 'required|min:1|max:50',
            'minimum_references' => 'required|min:0|max:50'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }

        $update_criteria = [];
        if(!empty($request->unit_id)){
            $update_criteria['unit_id'] = $request->unit_id;
        }
        else{
            $update_criteria['unit_id'] = 0;
        }
        
        ApplicationsLink::updateOrCreate(
            $update_criteria, 
            [
                'property_id' => $request->property_id,
                'unit_id' => $request->unit_id,
                'is_public' => $request->is_public,
                'previous_housings_years' => $request->previous_housings_years,
                'employers_years' => $request->employers_years,
                'minimum_references' => $request->minimum_references,
                'additional_information' => $request->additional_information,
                'unique_id' => Str::random(60)
            ]
        );
        
        return response()->json(['message' => 'success']);
        
    }
    
    public function getApplicationLink(Request $request)
    {
        
        $user_id = auth()->user()->id;
        $owner_id = User::getOwnerOfUser($user_id);
        
        $unit_id = $request->query('unit_id');
        $unit = Unit::find($unit_id);
        
        // check if unit exists
        if(empty($unit)){
            return response()->json(['message' => 'No unit found']);
        }
        
        $link = ApplicationsLink::where(['unit_id'=>$unit_id])->get();
        
        return response()->json(['data' => $link]);
        
    }
    
    // ---------------------------------------------------------------------------------------
    // ------------------------------  General Links End  ------------------------------------
    // ---------------------------------------------------------------------------------------
    
    
    
}