<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'mailgun' => [
        'domain' => env('MAILGUN_DOMAIN'),
        'secret' => env('MAILGUN_SECRET'),
        'endpoint' => env('MAILGUN_ENDPOINT', 'api.mailgun.net'),
    ],

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key' => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],
    
    'google' => [
        'client_id'     => env('GL_CLIENT_ID'),
        'client_secret' => env('GL_CLIENT_SECRET'),
        // 'redirect'      => env('APP_URL') . '/oauth/google/callback',
        'redirect'      => env('GL_REDIRECT_URL'),
    ],
    
    'facebook' => [
        'client_id'     => env('FL_CLIENT_ID'),
        'client_secret' => env('FL_CLIENT_SECRET'),
        'redirect'      => env('APP_URL') . 'public/oauth/facebook/callback'
    ],
    
    'linkedin' => [
        'client_id'     => env('LL_CLIENT_ID'),
        'client_secret' => env('LL_CLIENT_SECRET'),
        'redirect'      => env('LL_REDIRECT_URL'),
    ],

];
