<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\PropertiesMeasurement;
use App\Models\PropertiesHoaInteraction;
use App\Models\PropertiesMortageInteraction;
use App\Models\PropertiesBuildersInteraction;
use App\Models\PropertiesHoaInteractionsFile;
use App\Models\PropertiesMortageInteractionsFile;
use App\Models\PropertiesBuildersInteractionsFile;
use App\Models\PropertiesNote;
use App\Models\PropertiesNotesFile;
use App\Models\Unit;

class Property extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'unique_id',
        'type_id',
        'is_active',
        'address_line_1',
        'address_line_2',
        'country',
        'city',
        'state',
        'zip_code',
        'picture_template_id',
        'file_template_id',
        'embed',
        'wifi_network',
        'wifi_password',
        'alarm_code',
        'gate_code',
        'door_code',
        'mailbox_number',
        'other_info',
        'no_of_floors',
        'has_stairs',
        'has_elevator',
        'description',
        'other_property_features',
        'hoa_show_to_tenant',
        'hoa_show_to_property_manager',
        'hoa_company',
        'hoa_contact_firstname',
        'hoa_contact_lastname',
        'hoa_contact_title',
        'hoa_address_line1',
        'hoa_address_line2',
        'hoa_country',
        'hoa_city',
        'hoa_state',
        'hoa_zip_code',
        'hoa_number1',
        'hoa_number1_type',
        'hoa_number2',
        'hoa_number2_type',
        'hoa_number3',
        'hoa_number3_type',
        'hoa_email',
        'hoa_website',
        'hoa_fee',
        'hoa_fee_show_to_tenant',
        'hoa_fee_show_to_property_manager',
        'hoa_due_date',
        'hoa_tenant_notes',
        'hoa_property_manager_notes',
        'hoa_owner_notes',
        'mortage_company',
        'mortage_contact_firstname',
        'mortage_contact_lastname',
        'mortage_contact_title',
        'mortage_address_line1',
        'mortage_address_line2',
        'mortage_country',
        'mortage_city',
        'mortage_state',
        'mortage_zip_code',
        'mortage_number1',
        'mortage_number1_type',
        'mortage_number2',
        'mortage_number2_type',
        'mortage_number3',
        'mortage_number3_type',
        'mortage_email',
        'mortage_website',
        'mortage_minimum_payment',
        'mortage_due_date',
        'mortage_balance',
        'mortage_notes',
        'builder_company',
        'builder_date',
        'builder_firstname',
        'builder_lastname',
        'builder_title',
        'builder_address_line1',
        'builder_address_line2',
        'builder_country',
        'builder_city',
        'builder_state',
        'builder_zip_code',
        'builder_number1',
        'builder_number1_type',
        'builder_number2',
        'builder_number2_type',
        'builder_number3',
        'builder_number3_type',
        'builder_email',
        'builder_website',
        'builder_notes',
        'payment_info_company',
        'payment_info_firstname',
        'payment_info_lastname',
        'payment_info_address_line1',
        'payment_info_address_line2',
        'payment_info_country',
        'payment_info_city',
        'payment_info_state',
        'payment_info_zip_code',
        'payment_info_number',
        'payment_info_email',
        'payment_info_other_payment_information',
        'creator_id',
        'owner_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
    ];
    
    public function notifications()
    {
        return $this->hasMany(PropertiesNotification::class);
    }
    
    public function pictures()
    {
        return $this->hasMany(PropertiesPicture::class);
    }
    
    public function files()
    {
        return $this->hasMany(PropertiesFile::class);
    }

    public function contacts()
    {
        return $this->hasMany(PropertiesContact::class);
    }
    
    public function securitiesContacts()
    {
        return $this->hasMany(PropertiesSecuritiesContact::class);
    }
    
    
    public function parkingSpaces()
    {
        return $this->hasMany(PropertiesParkingSpace::class);
    }

    public function managers()
    {
        return $this->hasMany(PropertiesManager::class);
    }
    
    
    
    public function hoaFiles()
    {
        return $this->hasMany(PropertiesHoaFile::class);
    }
    
    public function hoaContacts()
    {
        return $this->hasMany(PropertiesHoaContact::class);
    }
    
    public function hoaInteractions($property_id)
    {
        
        $interactions = PropertiesHoaInteraction::where(['property_id'=>$property_id])->get();
            
        $interactions = (!empty($interactions)) ? $interactions->toArray() : [];
        
        for($i=0; $i<count($interactions); $i++){
            
            $interaction_id = $interactions[$i]['id'];
            
            $files = PropertiesHoaInteractionsFile::where(['property_hoa_interaction_id'=>$interaction_id])->get();
            $interactions[$i]['files'] = (!empty($files)) ? $files->toArray() : [];
            
        }
        
        return $interactions;
        
    }
    
    public function mortageFiles()
    {
        return $this->hasMany(PropertiesMortageFile::class);
    }
    
    public function mortageContacts()
    {
        return $this->hasMany(PropertiesMortageContact::class);
    }
    
    public function mortageInteractions($property_id)
    {
        
        $interactions = PropertiesMortageInteraction::where(['property_id'=>$property_id])->get();
            
        $interactions = (!empty($interactions)) ? $interactions->toArray() : [];
        
        for($i=0; $i<count($interactions); $i++){
            
            $interaction_id = $interactions[$i]['id'];
            
            $files = PropertiesMortageInteractionsFile::where(['property_mortage_interaction_id'=>$interaction_id])->get();
            $interactions[$i]['files'] = (!empty($files)) ? $files->toArray() : [];
            
        }
        
        return $interactions;
        
    }
    
    public function builderFiles()
    {
        return $this->hasMany(PropertiesBuildersFile::class);
    }
    
    public function builderContacts()
    {
        return $this->hasMany(PropertiesBuildersContact::class);
    }
    
    public function builderInteractions($property_id)
    {
        
        $interactions = PropertiesBuildersInteraction::where(['property_id'=>$property_id])->get();
            
        $interactions = (!empty($interactions)) ? $interactions->toArray() : [];
        
        for($i=0; $i<count($interactions); $i++){
            
            $interaction_id = $interactions[$i]['id'];
            
            $files = PropertiesBuildersInteractionsFile::where(['property_builder_interaction_id'=>$interaction_id])->get();
            $interactions[$i]['files'] = (!empty($files)) ? $files->toArray() : [];
            
        }
        
        return $interactions;
        
    }
    
    public function insurances()
    {
        return $this->hasMany(PropertiesInsurance::class);
    }
    
    public function insuranceClaims()
    {
        return $this->hasMany(PropertiesInsurancesClaim::class);
    }
    
    public function notices()
    {
        return $this->hasMany(PropertiesNotice::class);
    }
    
    public function boards()
    {
        return $this->hasMany(PropertiesBoard::class);
    }
    
    public function staffFiles()
    {
        return $this->hasMany(PropertiesStaffFile::class);
    }
    
    public function managersFiles()
    {
        return $this->hasMany(PropertiesManagersFile::class);
    }
    
    public function tenantsFiles()
    {
        return $this->hasMany(PropertiesTenantsFile::class);
    }
    
    public function ownersFiles()
    {
        return $this->hasMany(PropertiesOwnersFile::class);
    }
    
    public function allNotes($property_id)
    {
        $notes = PropertiesNote::where(['property_id'=>$property_id])->get();
        
        $notes = (!empty($notes)) ? $notes->toArray() : [];
        
        for($i=0; $i<count($notes); $i++){
            
            $note_id = $notes[$i]['id'];
            
            $files = PropertiesNotesFile::where(['property_note_id'=>$note_id])->get();
            $notes[$i]['files'] = (!empty($files)) ? $files->toArray() : [];
            
        }
        
        return $notes;
        
    }
    
    public function units()
    {
        return $this->hasMany(Unit::class);
    }
    
}
