<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

use App\Models\User;
use App\Models\Utility;

use Carbon\Carbon;

class UtilitiesController extends Controller
{
    
    protected $website_id;
    
    public function __construct(){
        
        $this->website_id = config('constants.website_id');
        
    }
    
    public function getAllUtilities()
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('get-all-utilities')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }
        
        $utilities = Utility::select(['id', 'utility', 'icon', 'order_number'])->where(['website_id'=>config('constants.website_id')])->get();
        
        $utilities = (!empty($utilities)) ? $utilities->toArray() : [];
        
        return response()->json(['message' => config('constants.messages.response_success'), 'data'=> ['utilities' => $utilities] ]);
    }

    public function utility(Request $request)
    {
        
        $user_id = auth()->user()->id;

        // check if permission to do
        if(!User::checkPermission('add-edit-utility')){
            return response()->json(config('constants.messages.permission_denied'), 400);
            exit();
        }

        $validator = Validator::make($request->all(), [
            'utility' => 'required',
            'icon' => 'required',
            'order_number' => 'required|numeric'
        ]);

        if ($validator->fails()) {
            return response()->json($validator->errors(), 400);
        }
        
        
        $update_criteria = [];
        if(!empty($request->id)){
            $update_criteria['id'] = $request->id;
        }
        else{
            $update_criteria['id'] = 0;
        }
        
        //$update_criteria = [];
        
        Utility::updateOrCreate(
            $update_criteria,
            [
                'utility' => $request->utility, 
                'icon' => $request->icon, 
                'order_number' => $request->order_number, 
                'created_by' => $user_id,
                'website_id' => $this->website_id
            ]
        );

        return response()->json(['message' => 'Success', 'data'=> [] ]);
        
    }
    
    
}