<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\PropertiesMeasurement;

class Unit extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'unique_id',
        'is_active',
        'property_id',
        'floor',
        'unit_status_id',
        'type_id',
        'bedrooms',
        'bathrooms',
        'stairs_to_unit',
        'stairs_in_unit',
        'elevator_to_unit',
        'elevator_in_unit',
        'monthly_rent',
        'security_deposit',
        'last_month_rent_required',
        'couples_allowed',
        'childern_allowed',
        'pets_allowed',
        'pets_deposit',
        'pets_rent',
        'pets_more_info',
        'smoking_permission_id',
        'lgbtq_friendly',
        'gender_preference_id',
        'wifi_network',
        'wifi_password',
        'alarm_code',
        'gate_code',
        'door_code',
        'mailbox_info',
        'other_info',
        'picture_template_id',
        'file_template_id',
        'is_parking_space_assigned',
        'property_parking_space_id',
        'embed',
        'listing_title',
        'listing_description',
        'other_unit_features',
        'owner_id',
        'creator_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
    ];
    
    public function unitLocations()
    {
        return $this->hasMany(UnitsLocation::class);
    }
    
    public function notifications()
    {
        return $this->hasMany(UnitsNotification::class);
    }
    
    public function boards()
    {
        return $this->hasMany(UnitsBoard::class);
    }
    
    public function pictures()
    {
        return $this->hasMany(UnitsPicture::class);
    }
    
    public function files()
    {
        return $this->hasMany(UnitsFile::class);
    }
    
    public function staffFiles()
    {
        return $this->hasMany(UnitsStaffFile::class);
    }
    
    public function managersFiles()
    {
        return $this->hasMany(UnitsManagersFile::class);
    }
    
    public function ownersFiles()
    {
        return $this->hasMany(UnitsOwnersFile::class);
    }
    
    public function utilities()
    {
        return $this->hasMany(UnitsUtility::class);
    }
    
    public function features()
    {
        return $this->hasMany(UnitsFeature::class);
    }
    
    public function allNotes()
    {
        return $this->hasMany(PropertiesNote::class);
    }
    
    
    
}
