<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\PropertiesNearby;

class PropertiesNearby extends Model
{
    use HasFactory;
    
    protected $table = 'properties_nearbys';
    
    protected $fillable = [
        'property_id',
        'nearby_id'
    ];    
    
    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        
    ];
    
    public function getPropertyNearbys($property_id)
    {
        
        if(empty($property_id)){
            return [];
        }
        
        $nearbys = PropertiesNearby::
            select(
                'properties_nearbys.*',
                'nearbys.name as nearby_name'
                )
            ->join('nearbys', 'properties_nearbys.nearby_id', '=', 'nearbys.id')
            ->where(['property_id'=>$property_id])->get();
            
    
        return $nearbys;
        
    }
    
    
}
