<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\PropertiesLocation;
use App\Models\PropertiesLocationsRole;
use App\Models\PropertiesLocationsRolesBase;

class PropertiesLocation extends Model
{
    use HasFactory;
    protected $fillable = [
        'location',
        'description',
        'can_reserve',
        'requires_approval',
        'deposit',
        'fee',
        'different_options_per_role',
        'owner_id',
        'property_id'
    ];
    
    public function getPropertyLocations($property_id)
    {
        
        if(empty($property_id)){
            return [];
        }
        
        $locations = PropertiesLocation::where(['property_id'=>$property_id])->get();
            
        $locations = (!empty($locations)) ? $locations->toArray() : [];
        
        for($i=0; $i<count($locations); $i++){
            
            $property_location_id = $locations[$i]['id'];
            
            $roles = PropertiesLocationsRole::where(['property_location_id'=>$property_location_id])->get();
            $locations[$i]['roles'] = (!empty($roles)) ? $roles->toArray() : [];
            
            $roles_basis = PropertiesLocationsRolesBase::where(['property_location_id'=>$property_location_id])->get();
            $locations[$i]['roles_basis'] = (!empty($roles_basis)) ? $roles_basis->toArray() : [];
            
        }
        
        return $locations;
        
    }
    
}
