<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\LoanableItemsPicture;
use App\Models\LoanableItemsSerialsNumber;

class LoanableItem extends Model
{
    use HasFactory;
    protected $fillable = [
        'name',
        'asset_assignee_user_type_id',
        'description',
        'replacement_cost',
        'track_inventory',
        'start_amount',
        'total',
        'on_hand',
        'loaned',
        'lost_damaged',
        'property_id',
        'creator_id',
        'owner_id'
    ];  
    
    public function getSingleLoanableItem($loanable_item_id){
        
        if(empty($loanable_item_id)){
            return [];
        }
        
        $loanable_item = parent::
            select(
                'loanable_items.*',
                'assets_assignees_users_types.type as asset_assignee_user_type'
                )
            ->join('assets_assignees_users_types', 'loanable_items.asset_assignee_user_type_id', '=', 'assets_assignees_users_types.id')
            ->where('loanable_items.id', $loanable_item_id)->first();
            
        $pictures = LoanableItemsPicture::where(['loanable_item_id'=>$loanable_item_id])->get();
        $loanable_item['pictures'] = (!empty($pictures)) ? $pictures->toArray() : [];
        
        $serial_numbers = LoanableItemsSerialsNumber::select(['id', 'serial_number'])->where(['loanable_item_id'=>$loanable_item_id])->get();
        $loanable_item['serial_numbers'] = (!empty($serial_numbers)) ? $serial_numbers->toArray() : [];
        
        return $loanable_item;
        
    }
    
    public function getLoanableItemsByOwnerId($owner_id){
        
        if(empty($owner_id)){
            return [];
        }
        
        $loanable_items = parent::
            select(
                'loanable_items.*',
                'assets_assignees_users_types.type as asset_assignee_user_type'
                )
            ->join('assets_assignees_users_types', 'loanable_items.asset_assignee_user_type_id', '=', 'assets_assignees_users_types.id')
            ->where(['owner_id'=>$owner_id])->get();
            
            
        $loanable_items = (!empty($loanable_items)) ? $loanable_items->toArray() : [];
        
        for($i=0; $i<count($loanable_items); $i++){
            
            $loanable_item_id = $loanable_items[$i]['id'];
            
            $pictures = LoanableItemsPicture::where(['loanable_item_id'=>$loanable_item_id])->get();
            $loanable_items[$i]['pictures'] = (!empty($pictures)) ? $pictures->toArray() : [];
            
            $serial_numbers = LoanableItemsSerialsNumber::select(['id', 'serial_number'])->where(['loanable_item_id'=>$loanable_item_id])->get();
            $loanable_items[$i]['serial_numbers'] = (!empty($serial_numbers)) ? $serial_numbers->toArray() : [];
            
        }
        
        return $loanable_items;
        
    }
    
}
